/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.datastore.memory;

import de.lmu.ifi.dbs.elki.database.datastore.DataStoreIDMap;
import de.lmu.ifi.dbs.elki.database.datastore.ObjectNotFoundException;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import java.util.Arrays;

public class ArrayStore<T>
implements WritableDataStore<T> {
    private Object[] data;
    private DataStoreIDMap idmap;

    public ArrayStore(Object[] data, DataStoreIDMap idmap) {
        this.data = data;
        this.idmap = idmap;
    }

    @Override
    public T get(DBIDRef id) {
        int off = this.idmap.mapDBIDToOffset(id);
        if (off < 0 || off >= this.data.length) {
            throw new ObjectNotFoundException(DBIDUtil.deref(id));
        }
        return (T)this.data[off];
    }

    @Override
    public T put(DBIDRef id, T value) {
        T ret = this.get(id);
        this.data[this.idmap.mapDBIDToOffset((DBIDRef)id)] = value;
        return ret;
    }

    @Override
    public void destroy() {
        this.data = null;
        this.idmap = null;
    }

    @Override
    public void delete(DBIDRef id) {
        this.put(id, null);
    }

    @Override
    public void clear() {
        Arrays.fill(this.data, null);
    }
}

