/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.datastore.memory;

import de.lmu.ifi.dbs.elki.database.datastore.WritableDBIDDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDFactory;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;

public class MapIntegerDBIDDBIDStore
implements WritableDBIDDataStore {
    private Int2IntMap map;

    public MapIntegerDBIDDBIDStore(int size) {
        this.map = new Int2IntOpenHashMap(size);
        this.map.defaultReturnValue(DBIDUtil.asInteger(DBIDUtil.invalid()));
    }

    @Override
    @Deprecated
    public DBID get(DBIDRef id) {
        return DBIDUtil.importInteger(this.map.get(DBIDUtil.asInteger(id)));
    }

    @Override
    @Deprecated
    public DBID put(DBIDRef id, DBID value) {
        return DBIDUtil.importInteger(this.map.put(DBIDUtil.asInteger(id), DBIDUtil.asInteger(value)));
    }

    @Override
    public void put(DBIDRef id, DBIDRef value) {
        this.map.put(DBIDUtil.asInteger(id), DBIDUtil.asInteger(value));
    }

    @Override
    public void putDBID(DBIDRef id, DBIDRef value) {
        this.map.put(DBIDUtil.asInteger(id), DBIDUtil.asInteger(value));
    }

    @Override
    public DBIDVar assignVar(DBIDRef id, DBIDVar var) {
        int val = this.map.get(DBIDUtil.asInteger(id));
        DBIDFactory.FACTORY.assignVar(var, val);
        return var;
    }

    @Override
    public void delete(DBIDRef id) {
        this.map.remove(DBIDUtil.asInteger(id));
    }

    @Override
    public void destroy() {
        this.map.clear();
        this.map = null;
    }

    @Override
    public void clear() {
        this.map.clear();
    }
}

