/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.datastore.memory;

import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import it.unimi.dsi.fastutil.ints.Int2DoubleOpenHashMap;

public class MapIntegerDBIDDoubleStore
implements WritableDoubleDataStore {
    private Int2DoubleOpenHashMap map;

    public MapIntegerDBIDDoubleStore(int size) {
        this(size, Double.NaN);
    }

    public MapIntegerDBIDDoubleStore(int size, double def) {
        this.map = new Int2DoubleOpenHashMap(size);
        this.map.defaultReturnValue(def);
    }

    @Override
    @Deprecated
    public Double get(DBIDRef id) {
        return this.map.get(DBIDUtil.asInteger(id));
    }

    @Override
    public double doubleValue(DBIDRef id) {
        return this.map.get(DBIDUtil.asInteger(id));
    }

    @Override
    @Deprecated
    public Double put(DBIDRef id, Double value) {
        return this.map.put(DBIDUtil.asInteger(id), (double)value);
    }

    @Override
    public void delete(DBIDRef id) {
        this.map.remove(DBIDUtil.asInteger(id));
    }

    @Override
    public double putDouble(DBIDRef id, double value) {
        return this.map.put(DBIDUtil.asInteger(id), value);
    }

    @Override
    public double put(DBIDRef id, double value) {
        return this.map.put(DBIDUtil.asInteger(id), value);
    }

    @Override
    public void increment(DBIDRef id, double value) {
        this.map.addTo(DBIDUtil.asInteger(id), value);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public void destroy() {
        this.map.clear();
        this.map = null;
    }
}

