/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.datastore.memory;

import de.lmu.ifi.dbs.elki.database.datastore.WritableIntegerDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;

public class MapIntegerDBIDIntegerStore
implements WritableIntegerDataStore {
    private Int2IntOpenHashMap map;

    public MapIntegerDBIDIntegerStore(int size) {
        this(size, 0);
    }

    public MapIntegerDBIDIntegerStore(int size, int def) {
        this.map = new Int2IntOpenHashMap(size);
        this.map.defaultReturnValue(def);
    }

    @Override
    @Deprecated
    public Integer get(DBIDRef id) {
        return this.map.get(DBIDUtil.asInteger(id));
    }

    @Override
    public int intValue(DBIDRef id) {
        return this.map.get(DBIDUtil.asInteger(id));
    }

    @Override
    @Deprecated
    public Integer put(DBIDRef id, Integer value) {
        return this.map.put(DBIDUtil.asInteger(id), (int)value);
    }

    @Override
    public void destroy() {
        this.map.clear();
        this.map = null;
    }

    @Override
    public void delete(DBIDRef id) {
        this.map.remove(DBIDUtil.asInteger(id));
    }

    @Override
    public int putInt(DBIDRef id, int value) {
        return this.map.put(DBIDUtil.asInteger(id), value);
    }

    @Override
    public int put(DBIDRef id, int value) {
        return this.map.put(DBIDUtil.asInteger(id), value);
    }

    @Override
    public void increment(DBIDRef id, int adjust) {
        this.map.addTo(DBIDUtil.asInteger(id), adjust);
    }

    @Override
    public void clear() {
        this.map.clear();
    }
}

