/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.datastore.memory;

import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableRecordStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;

public class MapIntegerDBIDRecordStore
implements WritableRecordStore {
    private final int rlen;
    private final Int2ObjectMap<Object[]> data;

    public MapIntegerDBIDRecordStore(int rlen, Int2ObjectMap<Object[]> data) {
        this.rlen = rlen;
        this.data = data;
    }

    public MapIntegerDBIDRecordStore(int rlen) {
        this(rlen, new Int2ObjectOpenHashMap<Object[]>());
    }

    public MapIntegerDBIDRecordStore(int size, int rlen) {
        this(rlen, new Int2ObjectOpenHashMap<Object[]>(size));
    }

    @Override
    public <T> WritableDataStore<T> getStorage(int col, Class<? super T> datatype) {
        return new StorageAccessor(col);
    }

    protected <T> T get(DBIDRef id, int index) {
        Object[] d = (Object[])this.data.get(DBIDUtil.asInteger(id));
        if (d == null) {
            return null;
        }
        return (T)d[index];
    }

    protected <T> T set(DBIDRef id, int index, T value) {
        Object[] d = (Object[])this.data.get(DBIDUtil.asInteger(id));
        if (d == null) {
            d = new Object[this.rlen];
            this.data.put(DBIDUtil.asInteger(id), d);
        }
        Object ret = d[index];
        d[index] = value;
        return (T)ret;
    }

    @Override
    public boolean remove(DBIDRef id) {
        return this.data.remove(DBIDUtil.asInteger(id)) != null;
    }

    protected class StorageAccessor<T>
    implements WritableDataStore<T> {
        private final int index;

        protected StorageAccessor(int index) {
            this.index = index;
        }

        @Override
        public T get(DBIDRef id) {
            return MapIntegerDBIDRecordStore.this.get(id, this.index);
        }

        @Override
        public T put(DBIDRef id, T value) {
            return MapIntegerDBIDRecordStore.this.set(id, this.index, value);
        }

        @Override
        public void destroy() {
            throw new UnsupportedOperationException("Record storage accessors cannot be destroyed.");
        }

        @Override
        public void delete(DBIDRef id) {
            throw new UnsupportedOperationException("Record storage accessors cannot be deleted.");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Record storage accessors cannot be cleared.");
        }
    }
}

