/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.datastore.memory;

import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;

public class MapIntegerDBIDStore<T>
implements WritableDataStore<T> {
    private Int2ObjectMap<T> data;

    public MapIntegerDBIDStore(Int2ObjectMap<T> data) {
        this.data = data;
    }

    public MapIntegerDBIDStore() {
        this.data = new Int2ObjectOpenHashMap<T>();
    }

    public MapIntegerDBIDStore(int size) {
        this.data = new Int2ObjectOpenHashMap<T>(size);
    }

    @Override
    public T get(DBIDRef id) {
        return (T)this.data.get(DBIDUtil.asInteger(id));
    }

    @Override
    public T put(DBIDRef id, T value) {
        if (value == null) {
            return (T)this.data.remove(DBIDUtil.asInteger(id));
        }
        return this.data.put(DBIDUtil.asInteger(id), value);
    }

    @Override
    public void destroy() {
        this.data = null;
    }

    @Override
    public void delete(DBIDRef id) {
        this.data.remove(DBIDUtil.asInteger(id));
    }

    @Override
    public void clear() {
        this.data.clear();
    }
}

