/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.datastore.memory;

import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableRecordStore;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MapRecordStore
implements WritableRecordStore {
    private final int rlen;
    private final Map<DBID, Object[]> data;

    public MapRecordStore(int rlen, Map<DBID, Object[]> data) {
        this.rlen = rlen;
        this.data = data;
    }

    public MapRecordStore(int rlen) {
        this(rlen, new ConcurrentHashMap<DBID, Object[]>());
    }

    @Override
    public <T> WritableDataStore<T> getStorage(int col, Class<? super T> datatype) {
        return new StorageAccessor(col);
    }

    protected <T> T get(DBIDRef id, int index) {
        Object[] d = this.data.get(DBIDUtil.deref(id));
        if (d == null) {
            return null;
        }
        return (T)d[index];
    }

    protected <T> T set(DBIDRef id, int index, T value) {
        Object[] d = this.data.get(DBIDUtil.deref(id));
        if (d == null) {
            d = new Object[this.rlen];
            this.data.put(DBIDUtil.deref(id), d);
        }
        Object ret = d[index];
        d[index] = value;
        return (T)ret;
    }

    @Override
    public boolean remove(DBIDRef id) {
        return this.data.remove(id) != null;
    }

    protected class StorageAccessor<T>
    implements WritableDataStore<T> {
        private final int index;

        protected StorageAccessor(int index) {
            this.index = index;
        }

        @Override
        public T get(DBIDRef id) {
            return MapRecordStore.this.get(id, this.index);
        }

        @Override
        public T put(DBIDRef id, T value) {
            return MapRecordStore.this.set(id, this.index, value);
        }

        @Override
        public void destroy() {
            throw new UnsupportedOperationException("Record storage accessors cannot be destroyed.");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Record storage accessors cannot (yet) be cleared.");
        }

        @Override
        public void delete(DBIDRef id) {
            throw new UnsupportedOperationException("Record storage values cannot be deleted.");
        }
    }
}

