/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.datastore.memory;

import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import java.util.HashMap;
import java.util.Map;

class MapStore<T>
implements WritableDataStore<T> {
    private Map<DBID, T> data;

    public MapStore(Map<DBID, T> data) {
        this.data = data;
    }

    public MapStore() {
        this.data = new HashMap<DBID, T>();
    }

    @Override
    public T get(DBIDRef id) {
        return this.data.get(DBIDUtil.deref(id));
    }

    @Override
    public T put(DBIDRef id, T value) {
        if (value == null) {
            return this.data.remove(DBIDUtil.deref(id));
        }
        return this.data.put(DBIDUtil.deref(id), value);
    }

    @Override
    public void destroy() {
        this.data = null;
    }

    @Override
    public void delete(DBIDRef id) {
        this.data.remove(id);
    }

    @Override
    public void clear() {
        this.data.clear();
    }
}

