/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.datastore.memory;

import de.lmu.ifi.dbs.elki.database.datastore.DataStoreFactory;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDBIDDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableIntegerDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableRecordStore;
import de.lmu.ifi.dbs.elki.database.datastore.memory.ArrayDBIDStore;
import de.lmu.ifi.dbs.elki.database.datastore.memory.ArrayDoubleStore;
import de.lmu.ifi.dbs.elki.database.datastore.memory.ArrayIntegerStore;
import de.lmu.ifi.dbs.elki.database.datastore.memory.ArrayRecordStore;
import de.lmu.ifi.dbs.elki.database.datastore.memory.ArrayStore;
import de.lmu.ifi.dbs.elki.database.datastore.memory.MapIntegerDBIDDBIDStore;
import de.lmu.ifi.dbs.elki.database.datastore.memory.MapIntegerDBIDDoubleStore;
import de.lmu.ifi.dbs.elki.database.datastore.memory.MapIntegerDBIDIntegerStore;
import de.lmu.ifi.dbs.elki.database.datastore.memory.MapIntegerDBIDRecordStore;
import de.lmu.ifi.dbs.elki.database.datastore.memory.MapIntegerDBIDStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRange;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;

public class MemoryDataStoreFactory
implements DataStoreFactory {
    @Override
    public <T> WritableDataStore<T> makeStorage(DBIDs ids, int hints, Class<? super T> dataclass) {
        if (Double.class.equals(dataclass)) {
            return this.makeDoubleStorage(ids, hints);
        }
        if (Integer.class.equals(dataclass)) {
            return this.makeIntegerStorage(ids, hints);
        }
        if (ids instanceof DBIDRange) {
            DBIDRange range = (DBIDRange)ids;
            Object[] data = new Object[range.size()];
            return new ArrayStore(data, range);
        }
        return new MapIntegerDBIDStore(ids.size());
    }

    @Override
    public WritableDBIDDataStore makeDBIDStorage(DBIDs ids, int hints) {
        if (ids instanceof DBIDRange) {
            DBIDRange range = (DBIDRange)ids;
            return new ArrayDBIDStore(range.size(), range);
        }
        return new MapIntegerDBIDDBIDStore(ids.size());
    }

    @Override
    public WritableDoubleDataStore makeDoubleStorage(DBIDs ids, int hints) {
        if (ids instanceof DBIDRange) {
            DBIDRange range = (DBIDRange)ids;
            return new ArrayDoubleStore(range.size(), range);
        }
        return new MapIntegerDBIDDoubleStore(ids.size());
    }

    @Override
    public WritableDoubleDataStore makeDoubleStorage(DBIDs ids, int hints, double def) {
        if (ids instanceof DBIDRange) {
            DBIDRange range = (DBIDRange)ids;
            return new ArrayDoubleStore(range.size(), range, def);
        }
        return new MapIntegerDBIDDoubleStore(ids.size(), def);
    }

    @Override
    public WritableIntegerDataStore makeIntegerStorage(DBIDs ids, int hints) {
        if (ids instanceof DBIDRange) {
            DBIDRange range = (DBIDRange)ids;
            return new ArrayIntegerStore(range.size(), range);
        }
        return new MapIntegerDBIDIntegerStore(ids.size());
    }

    @Override
    public WritableIntegerDataStore makeIntegerStorage(DBIDs ids, int hints, int def) {
        if (ids instanceof DBIDRange) {
            DBIDRange range = (DBIDRange)ids;
            return new ArrayIntegerStore(range.size(), range, def);
        }
        return new MapIntegerDBIDIntegerStore(ids.size(), def);
    }

    @Override
    public WritableRecordStore makeRecordStorage(DBIDs ids, int hints, Class<?> ... dataclasses) {
        if (ids instanceof DBIDRange) {
            DBIDRange range = (DBIDRange)ids;
            Object[][] data = new Object[range.size()][dataclasses.length];
            return new ArrayRecordStore(data, range);
        }
        return new MapIntegerDBIDRecordStore(ids.size(), dataclasses.length);
    }
}

