/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.ids;

import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDFactory;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDPair;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRange;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDPair;
import de.lmu.ifi.dbs.elki.database.ids.EmptyDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.HashSetDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.SetDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.StaticDBIDs;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.io.ByteBufferSerializer;
import de.lmu.ifi.dbs.elki.utilities.random.FastNonThreadsafeRandom;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.Random;

public final class DBIDUtil {
    public static final EmptyDBIDs EMPTYDBIDS = new EmptyDBIDs();

    private DBIDUtil() {
    }

    public static DBIDRef invalid() {
        return DBIDFactory.FACTORY.invalid();
    }

    public static DBID importInteger(int id) {
        return DBIDFactory.FACTORY.importInteger(id);
    }

    public static int asInteger(DBIDRef id) {
        return id.internalGetIndex();
    }

    public static int compare(DBIDRef id1, DBIDRef id2) {
        return DBIDFactory.FACTORY.compare(id1, id2);
    }

    public static boolean equal(DBIDRef id1, DBIDRef id2) {
        return DBIDFactory.FACTORY.equal(id1, id2);
    }

    public static DBID deref(DBIDRef ref) {
        return ref instanceof DBID ? (DBID)ref : DBIDUtil.importInteger(ref.internalGetIndex());
    }

    public static String toString(DBIDRef id) {
        return DBIDFactory.FACTORY.toString(id);
    }

    public static String toString(DBIDs ids) {
        DBIDFactory factory = DBIDFactory.FACTORY;
        if (ids instanceof DBID) {
            return factory.toString((DBID)ids);
        }
        if (ids.isEmpty()) {
            return "";
        }
        DBIDIter iter = ids.iter();
        StringBuilder buf = new StringBuilder(ids.size() * 6).append(factory.toString(iter));
        while (iter.advance().valid()) {
            buf.append(',').append(factory.toString(iter));
        }
        return buf.toString();
    }

    public static ByteBufferSerializer<DBID> getDBIDSerializer() {
        return DBIDFactory.FACTORY.getDBIDSerializer();
    }

    public static ByteBufferSerializer<DBID> getDBIDSerializerStatic() {
        return DBIDFactory.FACTORY.getDBIDSerializerStatic();
    }

    public static DBID generateSingleDBID() {
        return DBIDFactory.FACTORY.generateSingleDBID();
    }

    public static void deallocateSingleDBID(DBID id) {
        DBIDFactory.FACTORY.deallocateSingleDBID(id);
    }

    public static DBIDRange generateStaticDBIDRange(int size) {
        return DBIDFactory.FACTORY.generateStaticDBIDRange(size);
    }

    public static void deallocateDBIDRange(DBIDRange range) {
        DBIDFactory.FACTORY.deallocateDBIDRange(range);
    }

    public static DBIDVar newVar(DBIDRef val) {
        return DBIDFactory.FACTORY.newVar(val);
    }

    public static DBIDVar newVar() {
        return DBIDFactory.FACTORY.newVar(DBIDFactory.FACTORY.invalid());
    }

    public static ArrayModifiableDBIDs newArray() {
        return DBIDFactory.FACTORY.newArray();
    }

    public static HashSetModifiableDBIDs newHashSet() {
        return DBIDFactory.FACTORY.newHashSet();
    }

    public static ArrayModifiableDBIDs newArray(int size) {
        return DBIDFactory.FACTORY.newArray(size);
    }

    public static HashSetModifiableDBIDs newHashSet(int size) {
        return DBIDFactory.FACTORY.newHashSet(size);
    }

    public static ArrayModifiableDBIDs newArray(DBIDs existing) {
        return DBIDFactory.FACTORY.newArray(existing);
    }

    public static HashSetModifiableDBIDs newHashSet(DBIDs existing) {
        return DBIDFactory.FACTORY.newHashSet(existing);
    }

    public static ModifiableDBIDs intersection(DBIDs first, DBIDs second) {
        if (second instanceof SetDBIDs) {
            if (!(first instanceof SetDBIDs)) {
                return DBIDUtil.internalIntersection(first, second);
            }
        } else if (first instanceof SetDBIDs) {
            return DBIDUtil.internalIntersection(second, first);
        }
        return first.size() <= second.size() ? DBIDUtil.internalIntersection(first, second) : DBIDUtil.internalIntersection(second, first);
    }

    private static ModifiableDBIDs internalIntersection(DBIDs first, DBIDs second) {
        second = second.size() > 16 && !(second instanceof SetDBIDs) ? DBIDUtil.newHashSet(second) : second;
        HashSetModifiableDBIDs inter = DBIDUtil.newHashSet(first.size());
        DBIDIter it = first.iter();
        while (it.valid()) {
            if (second.contains(it)) {
                inter.add(it);
            }
            it.advance();
        }
        return inter;
    }

    public static int intersectionSize(DBIDs first, DBIDs second) {
        if (second instanceof SetDBIDs) {
            if (!(first instanceof SetDBIDs)) {
                return DBIDUtil.internalIntersectionSize(first, second);
            }
        } else if (first instanceof SetDBIDs) {
            return DBIDUtil.internalIntersectionSize(second, first);
        }
        return first.size() <= second.size() ? DBIDUtil.internalIntersectionSize(first, second) : DBIDUtil.internalIntersectionSize(second, first);
    }

    private static int internalIntersectionSize(DBIDs first, DBIDs second) {
        second = second.size() > 16 && !(second instanceof SetDBIDs) ? DBIDUtil.newHashSet(second) : second;
        int c = 0;
        DBIDIter it = first.iter();
        while (it.valid()) {
            if (second.contains(it)) {
                ++c;
            }
            it.advance();
        }
        return c;
    }

    public static void symmetricIntersection(DBIDs first, DBIDs second, HashSetModifiableDBIDs firstonly, HashSetModifiableDBIDs intersection, HashSetModifiableDBIDs secondonly) {
        if (first.size() > second.size()) {
            DBIDUtil.symmetricIntersection(second, first, secondonly, intersection, firstonly);
            return;
        }
        assert (firstonly.size() == 0) : "OUTPUT set should be empty!";
        assert (intersection.size() == 0) : "OUTPUT set should be empty!";
        assert (secondonly.size() == 0) : "OUTPUT set should be empty!";
        secondonly.addDBIDs(second);
        DBIDIter it = first.iter();
        while (it.valid()) {
            (secondonly.remove(it) ? intersection : firstonly).add(it);
            it.advance();
        }
    }

    public static ModifiableDBIDs union(DBIDs ids1, DBIDs ids2) {
        HashSetModifiableDBIDs result = DBIDUtil.newHashSet(Math.max(ids1.size(), ids2.size()));
        result.addDBIDs(ids1);
        result.addDBIDs(ids2);
        return result;
    }

    public static ModifiableDBIDs difference(DBIDs ids1, DBIDs ids2) {
        HashSetModifiableDBIDs result = DBIDUtil.newHashSet(ids1);
        result.removeDBIDs(ids2);
        return result;
    }

    public static StaticDBIDs makeUnmodifiable(DBIDs existing) {
        return DBIDFactory.FACTORY.makeUnmodifiable(existing);
    }

    public static ArrayDBIDs ensureArray(DBIDs ids) {
        return ids instanceof ArrayDBIDs ? (ArrayDBIDs)ids : DBIDUtil.newArray(ids);
    }

    public static SetDBIDs ensureSet(DBIDs ids) {
        return ids instanceof SetDBIDs ? (SetDBIDs)ids : DBIDUtil.newHashSet(ids);
    }

    public static ModifiableDBIDs ensureModifiable(DBIDs ids) {
        return ids instanceof ModifiableDBIDs ? (ModifiableDBIDs)ids : (ids instanceof HashSetDBIDs ? DBIDUtil.newHashSet(ids) : DBIDUtil.newArray(ids));
    }

    public static DBIDPair newPair(DBIDRef id1, DBIDRef id2) {
        return DBIDFactory.FACTORY.newPair(id1, id2);
    }

    public static DoubleDBIDPair newPair(double val, DBIDRef id) {
        return DBIDFactory.FACTORY.newPair(val, id);
    }

    public static KNNHeap newHeap(int k) {
        return DBIDFactory.FACTORY.newHeap(k);
    }

    public static KNNHeap newHeap(KNNList exist) {
        return DBIDFactory.FACTORY.newHeap(exist);
    }

    public static void randomShuffle(ArrayModifiableDBIDs ids, RandomFactory rnd) {
        DBIDUtil.randomShuffle(ids, rnd.getSingleThreadedRandom(), ids.size());
    }

    public static void randomShuffle(ArrayModifiableDBIDs ids, Random random) {
        DBIDUtil.randomShuffle(ids, random, ids.size());
    }

    public static void randomShuffle(ArrayModifiableDBIDs ids, Random random, int limit) {
        int end = ids.size();
        for (int i = 1; i < limit; ++i) {
            ids.swap(i - 1, i + random.nextInt(end - i));
        }
    }

    public static ModifiableDBIDs randomSample(DBIDs source, int k, int seed) {
        return DBIDUtil.randomSample(source, k, new Random(seed));
    }

    public static ModifiableDBIDs randomSample(DBIDs source, int k, Long seed) {
        return DBIDUtil.randomSample(source, k, seed != null ? new Random(seed) : new Random());
    }

    public static ModifiableDBIDs randomSample(DBIDs source, int k, RandomFactory rnd) {
        return DBIDUtil.randomSample(source, k, rnd.getSingleThreadedRandom());
    }

    public static ModifiableDBIDs randomSampleExcept(DBIDs source, DBIDRef except, int k, RandomFactory rnd) {
        return DBIDUtil.randomSampleExcept(source, except, k, rnd.getSingleThreadedRandom());
    }

    public static ModifiableDBIDs randomSample(DBIDs source, int k, Random random) {
        if (k < 0 || k > source.size()) {
            throw new IllegalArgumentException("Illegal value for size of random sample: " + k + " > " + source.size() + " or < 0");
        }
        Random random2 = random = random != null ? random : new FastNonThreadsafeRandom();
        if (k < source.size() >> 2) {
            ArrayDBIDs aids = DBIDUtil.ensureArray(source);
            DBIDArrayIter iter = aids.iter();
            int size = aids.size();
            HashSetModifiableDBIDs sample = DBIDUtil.newHashSet(k);
            while (sample.size() < k) {
                sample.add(iter.seek(random.nextInt(size)));
            }
            return sample;
        }
        ArrayModifiableDBIDs sample = DBIDUtil.newArray(source);
        DBIDUtil.randomShuffle(sample, random, k);
        for (int i = sample.size() - 1; i >= k; --i) {
            sample.remove(i);
        }
        return sample;
    }

    public static ModifiableDBIDs randomSampleExcept(DBIDs source, DBIDRef except, int k, Random random) {
        if (k < 0 || k > source.size()) {
            throw new IllegalArgumentException("Illegal value for size of random sample: " + k + " > " + source.size() + " or < 0");
        }
        Random random2 = random = random != null ? random : new FastNonThreadsafeRandom();
        if (k < source.size() >> 2) {
            ArrayDBIDs aids = DBIDUtil.ensureArray(source);
            DBIDArrayIter iter = aids.iter();
            int size = aids.size();
            HashSetModifiableDBIDs sample = DBIDUtil.newHashSet(k);
            while (sample.size() < k) {
                if (DBIDUtil.equal(iter.seek(random.nextInt(size)), except)) continue;
                sample.add(iter);
            }
            return sample;
        }
        ArrayModifiableDBIDs sample = DBIDUtil.newArray(source);
        DBIDUtil.randomShuffle(sample, random, k);
        DBIDArrayMIter iter = sample.iter();
        while (iter.valid() && iter.getOffset() < k) {
            if (DBIDUtil.equal(iter, except)) {
                sample.swap(iter.getOffset(), k);
                break;
            }
            iter.advance();
        }
        for (int i = sample.size() - 1; i >= k; --i) {
            sample.remove(i);
        }
        return sample;
    }

    public static DBIDs randomSample(DBIDs ids, double rate, RandomFactory random) {
        return DBIDUtil.randomSample(ids, rate, random.getSingleThreadedRandom());
    }

    public static DBIDs randomSample(DBIDs ids, double rate, Random random) {
        return rate <= 0.0 ? ids : DBIDUtil.randomSample(ids, Math.min(ids.size(), (int)(rate <= 1.0 ? rate * (double)ids.size() : rate)), random);
    }

    public static DBIDVar randomSample(DBIDs ids, Random random) {
        return DBIDUtil.ensureArray(ids).assignVar(random.nextInt(ids.size()), DBIDUtil.newVar());
    }

    public static DBIDVar randomSample(DBIDs ids, RandomFactory random) {
        return DBIDUtil.randomSample(ids, random.getSingleThreadedRandom());
    }

    public static ArrayDBIDs[] randomSplit(DBIDs ids, int p, RandomFactory rnd) {
        return DBIDUtil.randomSplit(ids, p, rnd.getSingleThreadedRandom());
    }

    public static ArrayDBIDs[] randomSplit(DBIDs oids, int p, Random random) {
        random = random != null ? random : new FastNonThreadsafeRandom();
        ArrayModifiableDBIDs ids = DBIDUtil.newArray(oids);
        int size = ids.size();
        ArrayDBIDs[] split = new ArrayDBIDs[p];
        for (int i = 1; i < size; ++i) {
            ids.swap(i - 1, i + random.nextInt(size - i));
        }
        int minsize = size / p;
        int extra = size % p;
        int beg = 0;
        for (int part = 0; part < p; ++part) {
            int psize = minsize + (part < extra ? 1 : 0);
            split[part] = ids.slice(beg, beg + psize);
            beg += psize;
        }
        return split;
    }

    public static ModifiableDoubleDBIDList newDistanceDBIDList(int size) {
        return DBIDFactory.FACTORY.newDistanceDBIDList(size);
    }

    public static ModifiableDoubleDBIDList newDistanceDBIDList() {
        return DBIDFactory.FACTORY.newDistanceDBIDList();
    }

    public static DBIDRange assertRange(DBIDs ids) {
        if (!(ids instanceof DBIDRange)) {
            throw new AbortException("This class may currently only be used with static databases and DBID ranges.");
        }
        return (DBIDRange)ids;
    }
}

