/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.ids;

import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListMIter;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import java.util.Comparator;

public class QuickSelectDBIDs {
    private static final int SMALL = 47;

    private QuickSelectDBIDs() {
    }

    private static final int bestPivot(int rank, int m1, int m2, int m3, int m4, int m5) {
        if (rank < m1) {
            return m1;
        }
        if (rank > m5) {
            return m5;
        }
        if (rank < m2) {
            return m2;
        }
        if (rank > m4) {
            return m4;
        }
        return m3;
    }

    public static void quickSelect(ArrayModifiableDBIDs data, Comparator<? super DBIDRef> comparator, int rank) {
        QuickSelectDBIDs.quickSelect(data, comparator, 0, data.size(), rank);
    }

    public static int median(ArrayModifiableDBIDs data, Comparator<? super DBIDRef> comparator) {
        return QuickSelectDBIDs.median(data, comparator, 0, data.size());
    }

    public static int median(ArrayModifiableDBIDs data, Comparator<? super DBIDRef> comparator, int begin, int end) {
        int length = end - begin;
        assert (length > 0);
        int left = begin + (length - 1 >> 1);
        QuickSelectDBIDs.quickSelect(data, comparator, begin, end, left);
        return left;
    }

    public static int quantile(ArrayModifiableDBIDs data, Comparator<? super DBIDRef> comparator, double quant) {
        return QuickSelectDBIDs.quantile(data, comparator, 0, data.size(), quant);
    }

    public static int quantile(ArrayModifiableDBIDs data, Comparator<? super DBIDRef> comparator, int begin, int end, double quant) {
        int length = end - begin;
        assert (length > 0) : "Quantile on empty set?";
        double dleft = (double)begin + (double)(length - 1) * quant;
        int ileft = (int)Math.floor(dleft);
        QuickSelectDBIDs.quickSelect(data, comparator, begin, end, ileft);
        return ileft;
    }

    public static void quickSelect(ArrayModifiableDBIDs data, Comparator<? super DBIDRef> comparator, int start, int end, int rank) {
        DBIDArrayMIter refi = data.iter();
        DBIDArrayMIter refj = data.iter();
        DBIDArrayMIter pivot = data.iter();
        while (true) {
            if (start + 47 > end) {
                QuickSelectDBIDs.insertionSort(data, comparator, start, end, refi, refj);
                return;
            }
            int len = end - start;
            int seventh = (len >> 3) + (len >> 6) + 1;
            int m3 = start + end >> 1;
            int m2 = m3 - seventh;
            int m1 = m2 - seventh;
            int m4 = m3 + seventh;
            int m5 = m4 + seventh;
            if (comparator.compare(refi.seek(m1), refj.seek(m2)) > 0) {
                data.swap(m1, m2);
            }
            if (comparator.compare(refi.seek(m1), refj.seek(m3)) > 0) {
                data.swap(m1, m3);
            }
            if (comparator.compare(refi.seek(m2), refj.seek(m3)) > 0) {
                data.swap(m2, m3);
            }
            if (comparator.compare(refi.seek(m4), refj.seek(m5)) > 0) {
                data.swap(m4, m5);
            }
            if (comparator.compare(refi.seek(m1), refj.seek(m4)) > 0) {
                data.swap(m1, m4);
            }
            if (comparator.compare(refi.seek(m3), refj.seek(m4)) > 0) {
                data.swap(m3, m4);
            }
            if (comparator.compare(refi.seek(m2), refj.seek(m5)) > 0) {
                data.swap(m2, m5);
            }
            if (comparator.compare(refi.seek(m2), refj.seek(m3)) > 0) {
                data.swap(m2, m3);
            }
            if (comparator.compare(refi.seek(m4), refj.seek(m5)) > 0) {
                data.swap(m4, m5);
            }
            int best = QuickSelectDBIDs.bestPivot(rank, m1, m2, m3, m4, m5);
            data.swap(best, end - 1);
            pivot.seek(end - 1);
            int i = start;
            int j = end - 2;
            while (true) {
                if (i <= j && comparator.compare(refi.seek(i), pivot) <= 0) {
                    ++i;
                    continue;
                }
                while (j >= i && comparator.compare(refj.seek(j), pivot) >= 0) {
                    --j;
                }
                if (i >= j) break;
                data.swap(i, j);
            }
            data.swap(i, end - 1);
            pivot.seek(i);
            while (rank < i && comparator.compare(refi.seek(i - 1), pivot) == 0) {
                --i;
            }
            while (rank > i && comparator.compare(refi.seek(i + 1), pivot) == 0) {
                ++i;
            }
            if (rank < i) {
                end = i;
                continue;
            }
            if (rank <= i) break;
            start = i + 1;
        }
    }

    private static void insertionSort(ArrayModifiableDBIDs data, Comparator<? super DBIDRef> comparator, int start, int end, DBIDArrayIter iter1, DBIDArrayIter iter2) {
        for (int i = start + 1; i < end; ++i) {
            for (int j = i; j > start && comparator.compare(iter1.seek(j - 1), iter2.seek(j)) > 0; --j) {
                data.swap(j, j - 1);
            }
        }
    }

    public static void quickSelect(ModifiableDoubleDBIDList data, int rank) {
        QuickSelectDBIDs.quickSelect(data, 0, data.size(), rank);
    }

    public static int median(ModifiableDoubleDBIDList data) {
        return QuickSelectDBIDs.median(data, 0, data.size());
    }

    public static int median(ModifiableDoubleDBIDList data, int begin, int end) {
        int length = end - begin;
        assert (length > 0);
        int left = begin + (length - 1 >> 1);
        QuickSelectDBIDs.quickSelect(data, begin, end, left);
        return left;
    }

    public static int quantile(ModifiableDoubleDBIDList data, double quant) {
        return QuickSelectDBIDs.quantile(data, 0, data.size(), quant);
    }

    public static int quantile(ModifiableDoubleDBIDList data, int begin, int end, double quant) {
        int length = end - begin;
        assert (length > 0) : "Quantile on empty set?";
        double dleft = (double)begin + (double)(length - 1) * quant;
        int ileft = (int)Math.floor(dleft);
        QuickSelectDBIDs.quickSelect(data, begin, end, ileft);
        return ileft;
    }

    public static void quickSelect(ModifiableDoubleDBIDList data, int start, int end, int rank) {
        DoubleDBIDListMIter refi = data.iter();
        DoubleDBIDListMIter refj = data.iter();
        DoubleDBIDListMIter pivot = data.iter();
        while (true) {
            if (start + 47 > end) {
                QuickSelectDBIDs.insertionSort(data, start, end, refi, refj);
                return;
            }
            int len = end - start;
            int seventh = (len >> 3) + (len >> 6) + 1;
            int m3 = start + end >> 1;
            int m2 = m3 - seventh;
            int m1 = m2 - seventh;
            int m4 = m3 + seventh;
            int m5 = m4 + seventh;
            if (refi.seek(m1).doubleValue() > refj.seek(m2).doubleValue()) {
                data.swap(m1, m2);
            }
            if (refi.seek(m1).doubleValue() > refj.seek(m3).doubleValue()) {
                data.swap(m1, m3);
            }
            if (refi.seek(m2).doubleValue() > refj.seek(m3).doubleValue()) {
                data.swap(m2, m3);
            }
            if (refi.seek(m4).doubleValue() > refj.seek(m5).doubleValue()) {
                data.swap(m4, m5);
            }
            if (refi.seek(m1).doubleValue() > refj.seek(m4).doubleValue()) {
                data.swap(m1, m4);
            }
            if (refi.seek(m3).doubleValue() > refj.seek(m4).doubleValue()) {
                data.swap(m3, m4);
            }
            if (refi.seek(m2).doubleValue() > refj.seek(m5).doubleValue()) {
                data.swap(m2, m5);
            }
            if (refi.seek(m2).doubleValue() > refj.seek(m3).doubleValue()) {
                data.swap(m2, m3);
            }
            if (refi.seek(m4).doubleValue() > refj.seek(m5).doubleValue()) {
                data.swap(m4, m5);
            }
            int best = QuickSelectDBIDs.bestPivot(rank, m1, m2, m3, m4, m5);
            data.swap(best, end - 1);
            double pivotv = pivot.seek(end - 1).doubleValue();
            int i = start;
            int j = end - 2;
            while (true) {
                if (i <= j && refi.seek(i).doubleValue() <= pivotv) {
                    ++i;
                    continue;
                }
                while (j >= i && refj.seek(j).doubleValue() >= pivotv) {
                    --j;
                }
                if (i >= j) break;
                data.swap(i, j);
            }
            data.swap(i, end - 1);
            pivot.seek(i);
            while (rank < i && refi.seek(i - 1).doubleValue() == pivotv) {
                --i;
            }
            while (rank > i && refi.seek(i + 1).doubleValue() == pivotv) {
                ++i;
            }
            if (rank < i) {
                end = i;
                continue;
            }
            if (rank <= i) break;
            start = i + 1;
        }
    }

    private static void insertionSort(ModifiableDoubleDBIDList data, int start, int end, DoubleDBIDListIter iter1, DoubleDBIDListIter iter2) {
        for (int i = start + 1; i < end; ++i) {
            for (int j = i; j > start && !(iter1.seek(j - 1).doubleValue() < iter2.seek(j).doubleValue()); --j) {
                data.swap(j, j - 1);
            }
        }
    }
}

