/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.ids.integer;

import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDFactory;
import de.lmu.ifi.dbs.elki.database.ids.DBIDPair;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDPair;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.StaticDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.integer.ArrayModifiableIntegerDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.integer.DoubleIntegerDBIDArrayList;
import de.lmu.ifi.dbs.elki.database.ids.integer.DoubleIntegerDBIDKNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.integer.DoubleIntegerDBIDPair;
import de.lmu.ifi.dbs.elki.database.ids.integer.FastutilIntOpenHashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBID;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDPair;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.integer.UnmodifiableIntegerArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.integer.UnmodifiableIntegerDBIDs;
import de.lmu.ifi.dbs.elki.utilities.io.ByteBufferSerializer;
import de.lmu.ifi.dbs.elki.utilities.io.FixedSizeByteBufferSerializer;

abstract class AbstractIntegerDBIDFactory
implements DBIDFactory {
    DBID invalid = new IntegerDBID(Integer.MIN_VALUE);

    AbstractIntegerDBIDFactory() {
    }

    @Override
    public DBID importInteger(int id) {
        return new IntegerDBID(id);
    }

    @Override
    public DBIDVar assignVar(DBIDVar var, int val) {
        assert (var instanceof IntegerDBIDVar);
        ((IntegerDBIDVar)var).internalSetIndex(val);
        return var;
    }

    @Override
    public int compare(DBIDRef a, DBIDRef b) {
        int intb;
        int inta = a.internalGetIndex();
        return inta < (intb = b.internalGetIndex()) ? -1 : (inta == intb ? 0 : 1);
    }

    @Override
    public boolean equal(DBIDRef a, DBIDRef b) {
        return a.internalGetIndex() == b.internalGetIndex();
    }

    @Override
    public String toString(DBIDRef id) {
        return id != null && id.internalGetIndex() != Integer.MIN_VALUE ? Integer.toString(id.internalGetIndex()) : "null";
    }

    @Override
    public DBIDVar newVar(DBIDRef val) {
        return new IntegerDBIDVar(val);
    }

    @Override
    public ArrayModifiableDBIDs newArray() {
        return new ArrayModifiableIntegerDBIDs();
    }

    @Override
    public HashSetModifiableDBIDs newHashSet() {
        return new FastutilIntOpenHashSetModifiableDBIDs();
    }

    @Override
    public ArrayModifiableDBIDs newArray(int size) {
        return new ArrayModifiableIntegerDBIDs(size);
    }

    @Override
    public HashSetModifiableDBIDs newHashSet(int size) {
        return new FastutilIntOpenHashSetModifiableDBIDs(size);
    }

    @Override
    public ArrayModifiableDBIDs newArray(DBIDs existing) {
        return new ArrayModifiableIntegerDBIDs(existing);
    }

    @Override
    public HashSetModifiableDBIDs newHashSet(DBIDs existing) {
        return new FastutilIntOpenHashSetModifiableDBIDs(existing);
    }

    @Override
    public DBIDPair newPair(DBIDRef first, DBIDRef second) {
        return new IntegerDBIDPair(first.internalGetIndex(), second.internalGetIndex());
    }

    @Override
    public DoubleDBIDPair newPair(double val, DBIDRef id) {
        return new DoubleIntegerDBIDPair(val, id.internalGetIndex());
    }

    @Override
    public KNNHeap newHeap(int k) {
        return new DoubleIntegerDBIDKNNHeap(k);
    }

    @Override
    public KNNHeap newHeap(KNNList exist) {
        KNNHeap heap = this.newHeap(exist.getK());
        DoubleDBIDListIter iter = exist.iter().seek(exist.size() - 1);
        while (iter.valid()) {
            heap.insert(iter.doubleValue(), iter);
            iter.retract();
        }
        return heap;
    }

    @Override
    public ModifiableDoubleDBIDList newDistanceDBIDList(int size) {
        return new DoubleIntegerDBIDArrayList(size);
    }

    @Override
    public ModifiableDoubleDBIDList newDistanceDBIDList() {
        return new DoubleIntegerDBIDArrayList();
    }

    @Override
    public StaticDBIDs makeUnmodifiable(DBIDs existing) {
        return existing instanceof StaticDBIDs ? (StaticDBIDs)existing : (existing instanceof IntegerArrayDBIDs ? new UnmodifiableIntegerArrayDBIDs((IntegerArrayDBIDs)existing) : new UnmodifiableIntegerDBIDs((IntegerDBIDs)existing));
    }

    @Override
    public ByteBufferSerializer<DBID> getDBIDSerializer() {
        return IntegerDBID.DYNAMIC_SERIALIZER;
    }

    @Override
    public FixedSizeByteBufferSerializer<DBID> getDBIDSerializerStatic() {
        return IntegerDBID.STATIC_SERIALIZER;
    }

    @Override
    public Class<? extends DBID> getTypeRestriction() {
        return IntegerDBID.class;
    }

    @Override
    public DBIDRef invalid() {
        return this.invalid;
    }
}

