/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.ids.integer;

import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBID;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDArrayMIter;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDArrayQuickSort;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDRange;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDVar;
import java.util.Arrays;
import java.util.Comparator;

class ArrayModifiableIntegerDBIDs
implements ArrayModifiableDBIDs,
IntegerArrayDBIDs {
    private int[] store;
    private int size;
    public static final int INITIAL_SIZE = 21;

    protected ArrayModifiableIntegerDBIDs(int isize) {
        this.store = new int[isize < 3 ? 3 : isize];
    }

    protected ArrayModifiableIntegerDBIDs() {
        this.store = new int[21];
    }

    protected ArrayModifiableIntegerDBIDs(DBIDs existing) {
        this(existing.size());
        if (existing instanceof IntegerDBIDRange) {
            IntegerDBIDRange range = (IntegerDBIDRange)existing;
            for (int i = 0; i < range.len; ++i) {
                this.store[i] = range.start + i;
            }
            this.size = range.len;
        } else {
            this.addDBIDs(existing);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public DBID get(int i) {
        return new IntegerDBID(this.store[i]);
    }

    @Override
    public DBIDVar assignVar(int index, DBIDVar var) {
        if (var instanceof IntegerDBIDVar) {
            ((IntegerDBIDVar)var).internalSetIndex(this.store[index]);
            return var;
        }
        var.set(this.get(index));
        return var;
    }

    private void ensureSize(int minsize) {
        if (minsize <= this.store.length) {
            return;
        }
        int asize = this.store.length;
        while (asize < minsize) {
            asize = (asize >>> 1) + asize;
        }
        int[] prev = this.store;
        this.store = new int[asize];
        System.arraycopy(prev, 0, this.store, 0, this.size);
    }

    private void grow() {
        int newsize = this.store.length + (this.store.length >>> 1);
        int[] prev = this.store;
        this.store = new int[newsize];
        System.arraycopy(prev, 0, this.store, 0, this.size);
    }

    @Override
    public boolean addDBIDs(DBIDs ids) {
        this.ensureSize(this.size + ids.size());
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            this.store[this.size] = iter.internalGetIndex();
            ++this.size;
            iter.advance();
        }
        return true;
    }

    @Override
    public boolean removeDBIDs(DBIDs ids) {
        boolean success = false;
        DBIDIter id = ids.iter();
        while (id.valid()) {
            int rm = id.internalGetIndex();
            for (int i = 0; i < this.size; ++i) {
                if (this.store[i] != rm) continue;
                --this.size;
                this.store[i] = this.store[this.size];
                success = true;
                break;
            }
            id.advance();
        }
        return success;
    }

    @Override
    public boolean add(DBIDRef e) {
        if (this.size == this.store.length) {
            this.grow();
        }
        this.store[this.size] = e.internalGetIndex();
        ++this.size;
        return true;
    }

    @Override
    public boolean remove(DBIDRef o) {
        int rm = o.internalGetIndex();
        for (int i = 0; i < this.size; ++i) {
            if (this.store[i] != rm) continue;
            --this.size;
            this.store[i] = this.store[this.size];
            return true;
        }
        return false;
    }

    @Override
    public void set(int index, DBIDRef element) {
        this.store[index] = element.internalGetIndex();
    }

    @Override
    public void insert(int i, DBIDRef newval) {
        if (this.size == this.store.length) {
            this.grow();
        }
        System.arraycopy(this.store, i, this.store, i + 1, this.size - i);
        this.store[i] = newval.internalGetIndex();
        ++this.size;
    }

    @Override
    public void remove(int index) {
        if (index < 0 || index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        if (--this.size > 0) {
            this.store[index] = this.store[this.size];
        }
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public int binarySearch(DBIDRef key) {
        return Arrays.binarySearch(this.store, 0, this.size, key.internalGetIndex());
    }

    @Override
    public boolean contains(DBIDRef o) {
        int oid = o.internalGetIndex();
        for (int i = 0; i < this.size; ++i) {
            if (this.store[i] != oid) continue;
            return true;
        }
        return false;
    }

    @Override
    public void sort() {
        Arrays.sort(this.store, 0, this.size);
    }

    @Override
    public void sort(Comparator<? super DBIDRef> comparator) {
        IntegerDBIDArrayQuickSort.sort(this.store, 0, this.size, comparator);
    }

    @Override
    public void sort(int start, int end, Comparator<? super DBIDRef> comparator) {
        IntegerDBIDArrayQuickSort.sort(this.store, start, end, comparator);
    }

    @Override
    public void swap(int a, int b) {
        int tmp = this.store[b];
        this.store[b] = this.store[a];
        this.store[a] = tmp;
    }

    @Override
    public DBIDVar pop(DBIDVar var) {
        if (this.size == 0) {
            throw new ArrayIndexOutOfBoundsException("Cannot pop() from an empty array.");
        }
        if (var instanceof IntegerDBIDVar) {
            ((IntegerDBIDVar)var).internalSetIndex(this.store[--this.size]);
        } else {
            var.set(this.get(--this.size));
        }
        return var;
    }

    @Override
    public Slice slice(int begin, int end) {
        return new Slice(begin, end);
    }

    @Override
    public Itr iter() {
        return new Itr();
    }

    public String toString() {
        return DBIDUtil.toString(this);
    }

    private class Slice
    implements IntegerArrayDBIDs {
        final int begin;
        final int end;

        public Slice(int begin, int end) {
            this.begin = begin;
            this.end = end;
        }

        @Override
        public int size() {
            return this.end - this.begin;
        }

        @Override
        public boolean contains(DBIDRef o) {
            int oid = o.internalGetIndex();
            for (int i = this.begin; i < this.end; ++i) {
                if (ArrayModifiableIntegerDBIDs.this.store[i] != oid) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isEmpty() {
            return this.begin == this.end;
        }

        @Override
        public DBID get(int i) {
            return ArrayModifiableIntegerDBIDs.this.get(this.begin + i);
        }

        @Override
        public DBIDVar assignVar(int index, DBIDVar var) {
            return ArrayModifiableIntegerDBIDs.this.assignVar(this.begin + index, var);
        }

        @Override
        public int binarySearch(DBIDRef key) {
            return Arrays.binarySearch(ArrayModifiableIntegerDBIDs.this.store, this.begin, this.end, key.internalGetIndex()) - this.begin;
        }

        @Override
        public SliceItr iter() {
            return new SliceItr();
        }

        @Override
        public Slice slice(int begin, int end) {
            return new Slice(begin + begin, begin + end);
        }

        private class SliceItr
        implements IntegerDBIDArrayIter {
            int pos;

            private SliceItr() {
                this.pos = Slice.this.begin;
            }

            @Override
            public int internalGetIndex() {
                return ArrayModifiableIntegerDBIDs.this.store[this.pos];
            }

            @Override
            public boolean valid() {
                return this.pos < Slice.this.end && this.pos >= Slice.this.begin;
            }

            @Override
            public SliceItr advance() {
                ++this.pos;
                return this;
            }

            @Override
            public int getOffset() {
                return this.pos - Slice.this.begin;
            }

            @Override
            public SliceItr advance(int count) {
                this.pos += count;
                return this;
            }

            @Override
            public SliceItr retract() {
                --this.pos;
                return this;
            }

            @Override
            public SliceItr seek(int off) {
                this.pos = off;
                return this;
            }

            public String toString() {
                return Integer.toString(this.internalGetIndex()) + "@" + this.pos;
            }
        }
    }

    private class Itr
    implements IntegerDBIDArrayMIter {
        int pos = 0;

        private Itr() {
        }

        @Override
        public int internalGetIndex() {
            return ArrayModifiableIntegerDBIDs.this.store[this.pos];
        }

        @Override
        public boolean valid() {
            return this.pos < ArrayModifiableIntegerDBIDs.this.size && this.pos >= 0;
        }

        @Override
        public Itr advance() {
            ++this.pos;
            return this;
        }

        @Override
        public int getOffset() {
            return this.pos;
        }

        @Override
        public Itr advance(int count) {
            this.pos += count;
            return this;
        }

        @Override
        public Itr retract() {
            --this.pos;
            return this;
        }

        @Override
        public Itr seek(int off) {
            this.pos = off;
            return this;
        }

        @Override
        public void setDBID(DBIDRef val) {
            if (this.pos == ArrayModifiableIntegerDBIDs.this.size) {
                ArrayModifiableIntegerDBIDs.this.add(val);
                return;
            }
            if (this.pos >= ArrayModifiableIntegerDBIDs.this.size) {
                throw new ArrayIndexOutOfBoundsException();
            }
            ((ArrayModifiableIntegerDBIDs)ArrayModifiableIntegerDBIDs.this).store[this.pos] = val.internalGetIndex();
        }

        @Override
        public void remove() {
            ArrayModifiableIntegerDBIDs.this.remove(this.pos--);
        }

        public String toString() {
            return Integer.toString(this.internalGetIndex()) + "@" + this.pos;
        }
    }
}

