/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.ids.integer;

import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDFactory;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerArrayStaticDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDVar;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import java.util.Arrays;

class ArrayStaticIntegerDBIDs
implements IntegerArrayStaticDBIDs {
    protected int[] store;

    protected ArrayStaticIntegerDBIDs(int ... ids) {
        this.store = ids;
    }

    @Override
    public int size() {
        return this.store.length;
    }

    @Override
    public boolean contains(DBIDRef o) {
        int oid = DBIDUtil.asInteger(o);
        for (int i = 0; i < this.store.length; ++i) {
            if (this.store[i] != oid) continue;
            return true;
        }
        return false;
    }

    @Override
    public DBID get(int i) {
        return DBIDFactory.FACTORY.importInteger(this.store[i]);
    }

    @Override
    public DBIDVar assignVar(int i, DBIDVar var) {
        if (var instanceof IntegerDBIDVar) {
            ((IntegerDBIDVar)var).internalSetIndex(this.store[i]);
            return var;
        }
        var.set(this.get(i));
        return var;
    }

    @Override
    public int binarySearch(DBIDRef key) {
        return Arrays.binarySearch(this.store, DBIDUtil.asInteger(key));
    }

    @Override
    public Itr iter() {
        return new Itr();
    }

    @Override
    public Slice slice(int begin, int end) {
        return new Slice(begin, end);
    }

    private class Slice
    implements IntegerArrayDBIDs {
        final int begin;
        final int end;

        public Slice(int begin, int end) {
            this.begin = begin;
            this.end = end;
        }

        @Override
        public int size() {
            return this.end - this.begin;
        }

        @Override
        public boolean contains(DBIDRef o) {
            int oid = o.internalGetIndex();
            for (int i = this.begin; i < this.end; ++i) {
                if (ArrayStaticIntegerDBIDs.this.store[i] != oid) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isEmpty() {
            return this.begin == this.end;
        }

        @Override
        public DBID get(int i) {
            return ArrayStaticIntegerDBIDs.this.get(this.begin + i);
        }

        @Override
        public DBIDVar assignVar(int index, DBIDVar var) {
            return ArrayStaticIntegerDBIDs.this.assignVar(this.begin + index, var);
        }

        @Override
        public int binarySearch(DBIDRef key) {
            return Arrays.binarySearch(ArrayStaticIntegerDBIDs.this.store, this.begin, this.end, key.internalGetIndex()) - this.begin;
        }

        @Override
        public SliceItr iter() {
            return new SliceItr();
        }

        @Override
        public Slice slice(int begin, int end) {
            return new Slice(begin + begin, begin + end);
        }

        private class SliceItr
        implements IntegerDBIDArrayIter {
            int pos;

            private SliceItr() {
                this.pos = Slice.this.begin;
            }

            @Override
            public int internalGetIndex() {
                return ArrayStaticIntegerDBIDs.this.store[this.pos];
            }

            @Override
            public boolean valid() {
                return this.pos < Slice.this.end && this.pos >= Slice.this.begin;
            }

            @Override
            public SliceItr advance() {
                ++this.pos;
                return this;
            }

            @Override
            public int getOffset() {
                return this.pos - Slice.this.begin;
            }

            @Override
            public SliceItr advance(int count) {
                this.pos += count;
                return this;
            }

            @Override
            public SliceItr retract() {
                --this.pos;
                return this;
            }

            @Override
            public SliceItr seek(int off) {
                this.pos = Slice.this.begin + off;
                return this;
            }

            public String toString() {
                return Integer.toString(this.internalGetIndex()) + "@" + this.pos;
            }
        }
    }

    protected class Itr
    implements IntegerDBIDArrayIter {
        int pos = 0;

        protected Itr() {
        }

        @Override
        public boolean valid() {
            return this.pos < ArrayStaticIntegerDBIDs.this.store.length && this.pos >= 0;
        }

        @Override
        public Itr advance() {
            ++this.pos;
            return this;
        }

        @Override
        public Itr advance(int count) {
            this.pos += 0;
            return this;
        }

        @Override
        public Itr retract() {
            --this.pos;
            return this;
        }

        @Override
        public Itr seek(int off) {
            this.pos = off;
            return this;
        }

        @Override
        public int getOffset() {
            return this.pos;
        }

        @Override
        public int internalGetIndex() {
            return ArrayStaticIntegerDBIDs.this.store[this.pos];
        }

        @Override
        public boolean equals(Object other) {
            if (other instanceof DBID) {
                LoggingUtil.warning("Programming error detected: DBIDItr.equals(DBID). Use sameDBID()!", new Throwable());
            }
            return super.equals(other);
        }

        public String toString() {
            return Integer.toString(this.internalGetIndex()) + "@" + this.pos;
        }
    }
}

