/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.ids.integer;

import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDPair;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.integer.DoubleIntegerDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.integer.DoubleIntegerDBIDListMIter;
import de.lmu.ifi.dbs.elki.database.ids.integer.DoubleIntegerDBIDSubList;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBID;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDVar;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arrays.DoubleIntegerArrayQuickSort;

class DoubleIntegerDBIDArrayList
implements ModifiableDoubleDBIDList,
DoubleIntegerDBIDList {
    private static final int INITIAL_SIZE = 21;
    int size;
    double[] dists;
    int[] ids;
    private static final double[] EMPTY_DISTS = new double[0];
    private static final int[] EMPTY_IDS = new int[0];

    protected DoubleIntegerDBIDArrayList() {
        this.dists = EMPTY_DISTS;
        this.ids = EMPTY_IDS;
    }

    protected DoubleIntegerDBIDArrayList(int size) {
        this.dists = size > 0 ? new double[size] : EMPTY_DISTS;
        this.ids = size > 0 ? new int[size] : EMPTY_IDS;
    }

    @Override
    public Itr iter() {
        return new Itr();
    }

    @Override
    public boolean contains(DBIDRef o) {
        int q = o.internalGetIndex();
        for (int i = 0; i < this.size; ++i) {
            if (q != this.ids[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public DBIDVar assignVar(int index, DBIDVar var) {
        assert (index < this.size) : "Index: " + index + " Size: " + this.size;
        if (var instanceof IntegerDBIDVar) {
            ((IntegerDBIDVar)var).internalSetIndex(this.ids[index]);
        } else {
            var.set(new IntegerDBID(this.ids[index]));
        }
        return var;
    }

    @Override
    public double doubleValue(int index) {
        assert (index < this.size) : "Index: " + index + " Size: " + this.size;
        return this.dists[index];
    }

    protected void addInternal(double dist, int id) {
        if (this.size == this.dists.length) {
            this.grow();
        }
        this.dists[this.size] = dist;
        this.ids[this.size] = id;
        ++this.size;
    }

    protected void grow() {
        if (this.dists == EMPTY_DISTS) {
            this.dists = new double[21];
            this.ids = new int[21];
            return;
        }
        int len = this.dists.length;
        int newlength = len + (len >> 1) + 1;
        double[] odists = this.dists;
        this.dists = new double[newlength];
        System.arraycopy(odists, 0, this.dists, 0, odists.length);
        int[] oids = this.ids;
        this.ids = new int[newlength];
        System.arraycopy(oids, 0, this.ids, 0, oids.length);
    }

    @Override
    public void add(double dist, DBIDRef id) {
        this.addInternal(dist, id.internalGetIndex());
    }

    @Override
    public void add(DoubleDBIDPair pair) {
        this.addInternal(pair.doubleValue(), pair.internalGetIndex());
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public void sort() {
        DoubleIntegerArrayQuickSort.sort(this.dists, this.ids, 0, this.size);
    }

    protected void reverse() {
        int i = 0;
        for (int j = this.size - 1; i < j; ++i, --j) {
            double tmpd = this.dists[j];
            this.dists[j] = this.dists[i];
            this.dists[i] = tmpd;
            int tmpi = this.ids[j];
            this.ids[j] = this.ids[i];
            this.ids[i] = tmpi;
        }
    }

    @Override
    public void remove(int index) {
        assert (index < this.size) : "Index: " + index + " Size: " + this.size;
        if (index < --this.size) {
            System.arraycopy(this.dists, index + 1, this.dists, index, this.size - index);
            System.arraycopy(this.ids, index + 1, this.ids, index, this.size - index);
        }
    }

    @Override
    public void removeSwap(int index) {
        assert (index < this.size) : "Index: " + index + " Size: " + this.size;
        if (--this.size > 0) {
            this.dists[index] = this.dists[this.size];
            this.ids[index] = this.ids[this.size];
        }
    }

    @Override
    public void swap(int i, int j) {
        assert (i < this.size) : "Index: " + i + " Size: " + this.size;
        assert (j < this.size) : "Index: " + j + " Size: " + this.size;
        double tmpd = this.dists[i];
        this.dists[i] = this.dists[j];
        this.dists[j] = tmpd;
        int tmpi = this.ids[i];
        this.ids[i] = this.ids[j];
        this.ids[j] = tmpi;
    }

    public void truncate(int newsize) {
        if (newsize < this.size) {
            double[] odists = this.dists;
            this.dists = new double[newsize];
            System.arraycopy(odists, 0, this.dists, 0, newsize);
            int[] oids = this.ids;
            this.ids = new int[newsize];
            System.arraycopy(oids, 0, this.ids, 0, newsize);
            this.size = newsize;
        }
    }

    @Override
    public DoubleIntegerDBIDList slice(int begin, int end) {
        return begin == 0 && end == this.size ? this : new DoubleIntegerDBIDSubList(this, begin, end);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(20 + this.size * 20).append("DoubleDBIDList[");
        Itr iter = this.iter();
        if (iter.valid()) {
            buf.append(iter.doubleValue()).append(':').append(iter.internalGetIndex());
            while (iter.advance().valid()) {
                buf.append(',').append(iter.doubleValue()).append(':').append(iter.internalGetIndex());
            }
        }
        return buf.append(']').toString();
    }

    private class Itr
    implements DoubleIntegerDBIDListMIter {
        int pos = 0;

        private Itr() {
        }

        @Override
        public boolean valid() {
            return this.pos < DoubleIntegerDBIDArrayList.this.size && this.pos >= 0;
        }

        @Override
        public Itr advance() {
            ++this.pos;
            return this;
        }

        @Override
        public int getOffset() {
            return this.pos;
        }

        @Override
        public Itr advance(int count) {
            this.pos += count;
            return this;
        }

        @Override
        public Itr retract() {
            --this.pos;
            return this;
        }

        @Override
        public Itr seek(int off) {
            this.pos = off;
            return this;
        }

        @Override
        public int internalGetIndex() {
            return DoubleIntegerDBIDArrayList.this.ids[this.pos];
        }

        @Override
        public double doubleValue() {
            return DoubleIntegerDBIDArrayList.this.dists[this.pos];
        }

        @Override
        public void remove() {
            DoubleIntegerDBIDArrayList.this.remove(this.pos--);
        }

        @Override
        public void setDBID(DBIDRef ref) {
            if (this.pos >= DoubleIntegerDBIDArrayList.this.size) {
                throw new ArrayIndexOutOfBoundsException();
            }
            DoubleIntegerDBIDArrayList.this.ids[this.pos] = ref.internalGetIndex();
        }

        @Override
        public void setDouble(double value) {
            if (this.pos >= DoubleIntegerDBIDArrayList.this.size) {
                throw new ArrayIndexOutOfBoundsException();
            }
            DoubleIntegerDBIDArrayList.this.dists[this.pos] = value;
        }

        public String toString() {
            return this.doubleValue() + ":" + this.internalGetIndex() + "@" + this.pos;
        }
    }
}

