/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.ids.integer;

import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDPair;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.integer.DoubleIntegerDBIDKNNList;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.DoubleIntegerHeap;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.DoubleIntegerMaxHeap;
import java.util.Arrays;
import net.jafama.FastMath;

class DoubleIntegerDBIDKNNHeap
implements KNNHeap {
    private final int k;
    private final DoubleIntegerMaxHeap heap;
    private int[] ties;
    private int numties = 0;
    private double kdist = Double.POSITIVE_INFINITY;
    private static final int INITIAL_TIES_SIZE = 11;

    protected DoubleIntegerDBIDKNNHeap(int k) {
        this.k = k;
        this.heap = new DoubleIntegerMaxHeap(k);
        this.ties = new int[11];
    }

    @Override
    public int getK() {
        return this.k;
    }

    @Override
    public double getKNNDistance() {
        return this.kdist;
    }

    @Override
    public final double insert(double distance, DBIDRef id) {
        if (this.heap.size() < this.k) {
            this.heap.add(distance, id.internalGetIndex());
            return this.heap.size() >= this.k ? (this.kdist = this.heap.peekKey()) : this.kdist;
        }
        if (distance >= this.kdist) {
            if (distance == this.kdist) {
                this.addToTies(id.internalGetIndex());
            }
            return this.kdist;
        }
        this.updateHeap(distance, id.internalGetIndex());
        return this.kdist;
    }

    @Override
    public void insert(DoubleDBIDPair e) {
        double distance = e.doubleValue();
        int iid = e.internalGetIndex();
        if (this.heap.size() < this.k) {
            this.heap.add(distance, iid);
            if (this.heap.size() >= this.k) {
                this.kdist = this.heap.peekKey();
            }
            return;
        }
        if (distance >= this.kdist) {
            if (distance == this.kdist) {
                this.addToTies(iid);
            }
            return;
        }
        this.updateHeap(distance, iid);
    }

    private void updateHeap(double distance, int iid) {
        double prevdist = this.kdist;
        int previd = this.heap.peekValue();
        this.heap.replaceTopElement(distance, iid);
        this.kdist = this.heap.peekKey();
        if (this.kdist < prevdist) {
            this.numties = 0;
        } else {
            this.addToTies(previd);
        }
    }

    private void addToTies(int id) {
        if (this.ties.length == this.numties) {
            this.ties = Arrays.copyOf(this.ties, (this.ties.length << 1) + 1);
        }
        this.ties[this.numties] = id;
        ++this.numties;
    }

    protected void pop() {
        if (this.numties > 0) {
            --this.numties;
        } else {
            this.heap.poll();
        }
    }

    @Override
    public int size() {
        return this.heap.size() + this.numties;
    }

    @Override
    public boolean isEmpty() {
        return this.heap.isEmpty();
    }

    @Override
    public void clear() {
        this.heap.clear();
        this.numties = 0;
    }

    @Override
    public DoubleIntegerDBIDKNNList toKNNList() {
        int hsize = this.heap.size();
        DoubleIntegerDBIDKNNList ret = new DoubleIntegerDBIDKNNList(this.k, hsize + this.numties);
        for (int i = 0; i < this.numties; ++i) {
            ret.dists[hsize + i] = this.kdist;
            ret.ids[hsize + i] = this.ties[i];
        }
        for (int j = hsize - 1; j >= 0; --j) {
            ret.dists[j] = this.heap.peekKey();
            ret.ids[j] = this.heap.peekValue();
            this.heap.poll();
        }
        ret.size = hsize + this.numties;
        return ret;
    }

    @Override
    public DoubleIntegerDBIDKNNList toKNNListSqrt() {
        int hsize = this.heap.size();
        DoubleIntegerDBIDKNNList ret = new DoubleIntegerDBIDKNNList(this.k, hsize + this.numties);
        double kdist = this.numties > 0 ? FastMath.sqrt(this.kdist) : 0.0;
        for (int i = 0; i < this.numties; ++i) {
            ret.dists[hsize + i] = kdist;
            ret.ids[hsize + i] = this.ties[i];
        }
        for (int j = hsize - 1; j >= 0; --j) {
            ret.dists[j] = FastMath.sqrt(this.heap.peekKey());
            ret.ids[j] = this.heap.peekValue();
            this.heap.poll();
        }
        ret.size = hsize + this.numties;
        return ret;
    }

    protected double peekDistance() {
        return this.numties > 0 ? this.kdist : this.heap.peekKey();
    }

    protected int peekInternalDBID() {
        return this.numties > 0 ? this.ties[this.numties - 1] : this.heap.peekValue();
    }

    @Override
    public boolean contains(DBIDRef o) {
        int q = o.internalGetIndex();
        for (int i = 0; i < this.numties; ++i) {
            if (this.ties[i] != q) continue;
            return true;
        }
        return this.heap.containsValue(q);
    }

    @Override
    public DoubleDBIDListIter unorderedIterator() {
        return new UnorderedIter();
    }

    private class UnorderedIter
    implements DoubleDBIDListIter {
        private DoubleIntegerHeap.UnsortedIter it;
        private int t;

        private UnorderedIter() {
            this.it = DoubleIntegerDBIDKNNHeap.this.heap.unsortedIter();
            this.t = 0;
        }

        @Override
        public int internalGetIndex() {
            return this.it.valid() ? this.it.getValue() : DoubleIntegerDBIDKNNHeap.this.ties[this.t];
        }

        @Override
        public boolean valid() {
            return this.it.valid() || this.t < DoubleIntegerDBIDKNNHeap.this.numties;
        }

        @Override
        public int getOffset() {
            throw new UnsupportedOperationException();
        }

        @Override
        public double doubleValue() {
            return this.it.valid() ? this.it.getKey() : DoubleIntegerDBIDKNNHeap.this.kdist;
        }

        @Override
        public DoubleDBIDListIter advance() {
            if (this.it.valid()) {
                this.it.advance();
            } else {
                ++this.t;
            }
            return this;
        }

        @Override
        public DoubleDBIDListIter advance(int count) {
            while (count-- > 0) {
                this.advance();
            }
            return this;
        }

        @Override
        public DoubleDBIDListIter retract() {
            throw new UnsupportedOperationException();
        }

        @Override
        public DoubleDBIDListIter seek(int off) {
            throw new UnsupportedOperationException();
        }
    }
}

