/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.ids.integer;

import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.integer.DoubleIntegerDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.integer.DoubleIntegerDBIDListIter;

public class DoubleIntegerDBIDSubList
implements DoubleIntegerDBIDList {
    private final int begin;
    private final int end;
    private final DoubleIntegerDBIDList inner;

    public DoubleIntegerDBIDSubList(DoubleIntegerDBIDList inner, int begin, int end) {
        this.inner = inner;
        assert (end < inner.size()) : "Access beyond size of list.";
        assert (begin >= 0 && end >= begin);
        this.begin = begin;
        this.end = end;
    }

    @Override
    public DBIDVar assignVar(int index, DBIDVar var) {
        assert ((index += this.begin) < this.end) : "Access beyond size of list.";
        return this.inner.assignVar(index, var);
    }

    @Override
    public double doubleValue(int index) {
        assert (index < this.end) : "Access beyond size of list.";
        return this.inner.doubleValue(index);
    }

    @Override
    public Itr iter() {
        return new Itr();
    }

    @Override
    public boolean contains(DBIDRef o) {
        Itr iter = this.iter();
        while (iter.valid()) {
            if (DBIDUtil.equal(iter, o)) {
                return true;
            }
            iter.advance();
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.begin == this.end;
    }

    @Override
    public int size() {
        return this.end - this.begin;
    }

    @Override
    public DoubleIntegerDBIDList slice(int begin, int end) {
        begin += this.begin;
        assert ((end += this.begin) < this.end) : "Access beyond size of list.";
        return new DoubleIntegerDBIDSubList(this.inner, begin, end);
    }

    private class Itr
    implements DoubleIntegerDBIDListIter {
        private DoubleIntegerDBIDListIter it;

        private Itr() {
            this.it = DoubleIntegerDBIDSubList.this.inner.iter().seek(DoubleIntegerDBIDSubList.this.begin);
        }

        @Override
        public boolean valid() {
            return this.it.getOffset() < DoubleIntegerDBIDSubList.this.end && this.it.getOffset() >= DoubleIntegerDBIDSubList.this.begin;
        }

        @Override
        public Itr advance() {
            this.it.advance();
            return this;
        }

        @Override
        public double doubleValue() {
            return this.it.doubleValue();
        }

        @Override
        public int internalGetIndex() {
            return this.it.internalGetIndex();
        }

        @Override
        public int getOffset() {
            return this.it.getOffset() - DoubleIntegerDBIDSubList.this.begin;
        }

        @Override
        public Itr advance(int count) {
            this.it.advance(count);
            return this;
        }

        @Override
        public Itr retract() {
            this.it.retract();
            return this;
        }

        @Override
        public Itr seek(int off) {
            this.it.seek(DoubleIntegerDBIDSubList.this.begin + off);
            return this;
        }
    }
}

