/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.ids.integer;

import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDMIter;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDs;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.NoSuchElementException;

class FastutilIntOpenHashSetModifiableDBIDs
implements HashSetModifiableDBIDs,
IntegerDBIDs {
    IntOpenHashSet store;

    protected FastutilIntOpenHashSetModifiableDBIDs(int size) {
        this.store = new IntOpenHashSet(size);
    }

    protected FastutilIntOpenHashSetModifiableDBIDs() {
        this.store = new IntOpenHashSet();
    }

    protected FastutilIntOpenHashSetModifiableDBIDs(DBIDs existing) {
        this(existing.size());
        this.addDBIDs(existing);
    }

    @Override
    public Itr iter() {
        return new Itr(this.store.iterator());
    }

    @Override
    public boolean addDBIDs(DBIDs ids) {
        boolean success = false;
        DBIDIter iter = ids.iter();
        while (iter.valid()) {
            success |= this.store.add(DBIDUtil.asInteger(iter));
            iter.advance();
        }
        return success;
    }

    @Override
    public boolean removeDBIDs(DBIDs ids) {
        boolean success = false;
        DBIDIter id = ids.iter();
        while (id.valid()) {
            success |= this.store.remove(DBIDUtil.asInteger(id));
            id.advance();
        }
        return success;
    }

    @Override
    public boolean add(DBIDRef e) {
        return this.store.add(DBIDUtil.asInteger(e));
    }

    @Override
    public boolean remove(DBIDRef o) {
        return this.store.remove(DBIDUtil.asInteger(o));
    }

    @Override
    public boolean retainAll(DBIDs set) {
        boolean modified = false;
        Itr it = this.iter();
        while (it.valid()) {
            if (!set.contains(it)) {
                it.remove();
                modified = true;
            }
            it.advance();
        }
        return modified;
    }

    @Override
    public int size() {
        return this.store.size();
    }

    @Override
    public boolean isEmpty() {
        return this.store.isEmpty();
    }

    @Override
    public void clear() {
        this.store.clear();
    }

    @Override
    public boolean contains(DBIDRef o) {
        return this.store.contains(DBIDUtil.asInteger(o));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('[');
        Itr iter = this.iter();
        while (iter.valid()) {
            if (buf.length() > 1) {
                buf.append(", ");
            }
            buf.append(((Object)iter).toString());
            iter.advance();
        }
        buf.append(']');
        return buf.toString();
    }

    @Override
    public DBIDVar pop(DBIDVar outvar) {
        if (this.store.size() == 0) {
            throw new NoSuchElementException("Cannot pop() from an empty array.");
        }
        int val = this.store.popInt();
        if (outvar instanceof IntegerDBIDVar) {
            ((IntegerDBIDVar)outvar).internalSetIndex(val);
        } else {
            outvar.set(DBIDUtil.importInteger(val));
        }
        this.store.remove(val);
        return outvar;
    }

    protected static class Itr
    implements IntegerDBIDMIter {
        IntIterator it;
        int prev;

        public Itr(IntIterator it) {
            if (it != null && it.hasNext()) {
                this.it = it;
                this.prev = it.nextInt();
            }
        }

        @Override
        public boolean valid() {
            return this.it != null;
        }

        @Override
        public IntegerDBIDMIter advance() {
            if (this.it != null && this.it.hasNext()) {
                this.prev = this.it.nextInt();
            } else {
                this.it = null;
            }
            return this;
        }

        @Override
        public int internalGetIndex() {
            return this.prev;
        }

        public String toString() {
            return Integer.toString(this.internalGetIndex());
        }

        @Override
        public void remove() {
            this.it.remove();
        }
    }

    private static class IntOpenHashSet
    extends it.unimi.dsi.fastutil.ints.IntOpenHashSet {
        private static final long serialVersionUID = 1L;
        private transient int c = -1;

        public IntOpenHashSet() {
        }

        public IntOpenHashSet(int size) {
            super(size);
        }

        public int popInt() {
            int k;
            int pos;
            if (this.size == 0) {
                throw new NoSuchElementException();
            }
            if (this.containsNull) {
                this.containsNull = false;
                --this.size;
                return 0;
            }
            int[] key = this.key;
            int n = pos = this.c < key.length ? this.c : key.length;
            do {
                if (pos > 0) continue;
                pos = key.length;
            } while ((k = key[--pos]) == 0);
            --this.size;
            this.shiftKeys(pos);
            if (this.size < this.maxFill >> 2 && this.n > 16) {
                this.rehash(this.n >> 1);
            }
            this.c = pos;
            return k;
        }
    }
}

