/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.ids.integer;

import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDRef;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.utilities.io.ByteArrayUtil;
import de.lmu.ifi.dbs.elki.utilities.io.ByteBufferSerializer;
import de.lmu.ifi.dbs.elki.utilities.io.FixedSizeByteBufferSerializer;
import java.io.IOException;
import java.nio.ByteBuffer;

final class IntegerDBID
implements DBID,
IntegerDBIDRef {
    protected final int id;
    public static final ByteBufferSerializer<DBID> DYNAMIC_SERIALIZER = new DynamicSerializer();
    public static final FixedSizeByteBufferSerializer<DBID> STATIC_SERIALIZER = new StaticSerializer();

    protected IntegerDBID(int id) {
        this.id = id;
    }

    protected IntegerDBID(Integer id) {
        this.id = id;
    }

    @Override
    public int internalGetIndex() {
        return this.id;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public String toString() {
        return this.id != Integer.MIN_VALUE ? Integer.toString(this.id) : "null";
    }

    @Override
    public int hashCode() {
        return this.id;
    }

    @Override
    @Deprecated
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IntegerDBID)) {
            if (obj instanceof DBIDRef) {
                LoggingUtil.warning("Programming error: DBID.equals(DBIDRef) is not well-defined. Use DBIDUtil.equal() instead!", new Throwable());
            }
            return false;
        }
        IntegerDBID other = (IntegerDBID)obj;
        return this.id == other.id;
    }

    @Override
    public int compareTo(DBIDRef o) {
        int anotherVal = o.internalGetIndex();
        return this.id < anotherVal ? -1 : (this.id == anotherVal ? 0 : 1);
    }

    @Override
    public Itr iter() {
        return new Itr();
    }

    @Override
    public DBID get(int i) {
        if (i != 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this;
    }

    @Override
    public DBIDVar assignVar(int index, DBIDVar var) {
        if (index != 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        var.set(this);
        return var;
    }

    @Override
    public boolean contains(DBIDRef o) {
        return o.internalGetIndex() == this.id;
    }

    @Override
    public int binarySearch(DBIDRef key) {
        int other = key.internalGetIndex();
        return other == this.id ? 0 : (other < this.id ? -1 : -2);
    }

    @Override
    public ArrayDBIDs slice(int begin, int end) {
        if (begin == 0 && end == 1) {
            return this;
        }
        return DBIDUtil.EMPTYDBIDS;
    }

    public static class StaticSerializer
    implements FixedSizeByteBufferSerializer<DBID> {
        @Override
        public DBID fromByteBuffer(ByteBuffer buffer) throws IOException {
            return new IntegerDBID(buffer.getInt());
        }

        @Override
        public void toByteBuffer(ByteBuffer buffer, DBID object) throws IOException {
            buffer.putInt(((IntegerDBID)object).id);
        }

        @Override
        public int getByteSize(DBID object) throws IOException {
            return this.getFixedByteSize();
        }

        @Override
        public int getFixedByteSize() {
            return 4;
        }
    }

    public static class DynamicSerializer
    implements ByteBufferSerializer<DBID> {
        @Override
        public DBID fromByteBuffer(ByteBuffer buffer) throws IOException {
            return new IntegerDBID(ByteArrayUtil.readSignedVarint(buffer));
        }

        @Override
        public void toByteBuffer(ByteBuffer buffer, DBID object) throws IOException {
            ByteArrayUtil.writeSignedVarint(buffer, ((IntegerDBID)object).id);
        }

        @Override
        public int getByteSize(DBID object) throws IOException {
            return ByteArrayUtil.getSignedVarintSize(((IntegerDBID)object).id);
        }
    }

    protected class Itr
    implements DBIDArrayIter,
    IntegerDBIDRef {
        int pos = 0;

        protected Itr() {
        }

        @Override
        public Itr advance() {
            ++this.pos;
            return this;
        }

        @Override
        public Itr advance(int count) {
            this.pos += count;
            return this;
        }

        @Override
        public Itr retract() {
            --this.pos;
            return this;
        }

        @Override
        public Itr seek(int off) {
            this.pos = off;
            return this;
        }

        @Override
        public int getOffset() {
            return this.pos;
        }

        @Override
        public int internalGetIndex() {
            return IntegerDBID.this.id;
        }

        @Override
        public boolean valid() {
            return this.pos == 0;
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public boolean equals(Object other) {
            if (other instanceof DBID) {
                LoggingUtil.warning("Programming error detected: DBIDItr.equals(DBID). Use sameDBID()!", new Throwable());
            }
            return super.equals(other);
        }

        public String toString() {
            return Integer.toString(this.internalGetIndex());
        }
    }
}

