/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.ids.integer;

import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDVar;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import java.util.Comparator;

@Reference(authors="V. Yaroslavskiy", title="Dual-Pivot Quicksort", booktitle="", url="http://iaroslavski.narod.ru/quicksort/", bibkey="web/Yaroslavskiy09")
final class IntegerDBIDArrayQuickSort {
    private static final int INSERTION_THRESHOLD = 47;

    private IntegerDBIDArrayQuickSort() {
    }

    public static void sort(int[] data, Comparator<? super DBIDRef> comp) {
        IntegerDBIDArrayQuickSort.sort(data, 0, data.length, comp);
    }

    public static void sort(int[] data, int start, int end, Comparator<? super DBIDRef> comp) {
        IntegerDBIDArrayQuickSort.quickSort(data, start, end - 1, comp, new IntegerDBIDVar(), new IntegerDBIDVar(), new IntegerDBIDVar());
    }

    private static void quickSort(int[] data, int start, int end, Comparator<? super DBIDRef> comp, IntegerDBIDVar vl, IntegerDBIDVar vk, IntegerDBIDVar vr) {
        int tmp;
        int len = end - start;
        if (len < 47) {
            block0: for (int i = start + 1; i <= end; ++i) {
                for (int j = i; j > start; --j) {
                    vl.internalSetIndex(data[j]);
                    vr.internalSetIndex(data[j - 1]);
                    if (comp.compare(vl, vr) >= 0) continue block0;
                    int tmp2 = data[j - 1];
                    data[j - 1] = data[j];
                    data[j] = tmp2;
                }
            }
            return;
        }
        int seventh = (len >> 3) + (len >> 6) + 1;
        int m3 = start + end >> 1;
        int m2 = m3 - seventh;
        int m1 = m2 - seventh;
        int m4 = m3 + seventh;
        int m5 = m4 + seventh;
        if (IntegerDBIDArrayQuickSort.compare(vl, data[m1], vk, data[m2], comp) > 0) {
            tmp = data[m2];
            data[m2] = data[m1];
            data[m1] = tmp;
        }
        if (IntegerDBIDArrayQuickSort.compare(vl, data[m1], vk, data[m3], comp) > 0) {
            tmp = data[m3];
            data[m3] = data[m1];
            data[m1] = tmp;
        }
        if (IntegerDBIDArrayQuickSort.compare(vl, data[m2], vk, data[m3], comp) > 0) {
            tmp = data[m3];
            data[m3] = data[m2];
            data[m2] = tmp;
        }
        if (IntegerDBIDArrayQuickSort.compare(vl, data[m4], vk, data[m5], comp) > 0) {
            tmp = data[m5];
            data[m5] = data[m4];
            data[m4] = tmp;
        }
        if (IntegerDBIDArrayQuickSort.compare(vl, data[m1], vk, data[m4], comp) > 0) {
            tmp = data[m4];
            data[m4] = data[m1];
            data[m1] = tmp;
        }
        if (IntegerDBIDArrayQuickSort.compare(vl, data[m3], vk, data[m4], comp) > 0) {
            tmp = data[m4];
            data[m4] = data[m3];
            data[m3] = tmp;
        }
        if (IntegerDBIDArrayQuickSort.compare(vl, data[m2], vk, data[m5], comp) > 0) {
            tmp = data[m5];
            data[m5] = data[m2];
            data[m2] = tmp;
        }
        if (IntegerDBIDArrayQuickSort.compare(vl, data[m2], vk, data[m3], comp) > 0) {
            tmp = data[m3];
            data[m3] = data[m2];
            data[m2] = tmp;
        }
        if (IntegerDBIDArrayQuickSort.compare(vl, data[m4], vk, data[m5], comp) > 0) {
            tmp = data[m5];
            data[m5] = data[m4];
            data[m4] = tmp;
        }
        vl.internalSetIndex(data[m2]);
        vr.internalSetIndex(data[m4]);
        data[m2] = data[start];
        data[m4] = data[end];
        boolean tied = comp.compare(vl, vr) == 0;
        int left = start + 1;
        int right = end - 1;
        for (int k = left; k <= right; ++k) {
            int tmp3 = data[k];
            vk.internalSetIndex(tmp3);
            int c = comp.compare(vk, vl);
            if (c == 0) continue;
            if (c < 0) {
                data[k] = data[left];
                data[left] = tmp3;
                ++left;
                continue;
            }
            if (!tied && comp.compare(vk, vr) <= 0) continue;
            while (true) {
                vk.internalSetIndex(data[right]);
                if (comp.compare(vk, vr) <= 0 || k >= right) break;
                --right;
            }
            data[k] = data[right];
            data[right] = tmp3;
            --right;
            vk.internalSetIndex(data[k]);
            if (comp.compare(vk, vl) >= 0) continue;
            tmp3 = data[k];
            data[k] = data[left];
            data[left] = tmp3;
            ++left;
        }
        data[start] = data[left - 1];
        data[left - 1] = vl.internalGetIndex();
        data[end] = data[right + 1];
        data[right + 1] = vr.internalGetIndex();
        IntegerDBIDArrayQuickSort.quickSort(data, start, left - 2, comp, vl, vk, vr);
        if (!tied) {
            IntegerDBIDArrayQuickSort.quickSort(data, left, right, comp, vl, vk, vr);
        }
        IntegerDBIDArrayQuickSort.quickSort(data, right + 2, end, comp, vl, vk, vr);
    }

    private static int compare(IntegerDBIDVar i1, int p1, IntegerDBIDVar i2, int p2, Comparator<? super DBIDRef> comp) {
        i1.internalSetIndex(p1);
        i2.internalSetIndex(p2);
        return comp.compare(i1, i2);
    }
}

