/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.ids.integer;

import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.ids.integer.DoubleIntegerDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDKNNList;

public class IntegerDBIDKNNSubList
implements IntegerDBIDKNNList {
    private final int k;
    private final int size;
    private final IntegerDBIDKNNList inner;

    public IntegerDBIDKNNSubList(IntegerDBIDKNNList inner, int k) {
        this.inner = inner;
        this.k = k;
        if (k < inner.getK()) {
            DoubleDBIDListIter iter = inner.iter();
            double kdist = iter.seek(k - 1).doubleValue();
            int i = k;
            iter.advance();
            while (iter.valid() && iter.doubleValue() <= kdist) {
                ++i;
                iter.advance();
            }
            this.size = i;
        } else {
            this.size = inner.size();
        }
    }

    @Override
    public int getK() {
        return this.k;
    }

    @Override
    public DBIDVar assignVar(int index, DBIDVar var) {
        assert (index < this.size) : "Access beyond design size of list.";
        return this.inner.assignVar(index, var);
    }

    @Override
    public double doubleValue(int index) {
        assert (index < this.size) : "Access beyond design size of list.";
        return this.inner.doubleValue(index);
    }

    @Override
    public double getKNNDistance() {
        return this.inner.doubleValue(this.k - 1);
    }

    @Override
    public Itr iter() {
        return new Itr();
    }

    @Override
    public boolean contains(DBIDRef o) {
        Itr iter = this.iter();
        while (iter.valid()) {
            if (DBIDUtil.equal(iter, o)) {
                return true;
            }
            iter.advance();
        }
        return false;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public KNNList subList(int k) {
        return new IntegerDBIDKNNSubList(this.inner, k);
    }

    private class Itr
    implements DoubleIntegerDBIDListIter {
        private DoubleIntegerDBIDListIter inneriter;

        private Itr() {
            this.inneriter = IntegerDBIDKNNSubList.this.inner.iter();
        }

        @Override
        public boolean valid() {
            return this.inneriter.getOffset() < IntegerDBIDKNNSubList.this.size && this.inneriter.valid();
        }

        @Override
        public Itr advance() {
            this.inneriter.advance();
            return this;
        }

        @Override
        public double doubleValue() {
            return this.inneriter.doubleValue();
        }

        @Override
        public int internalGetIndex() {
            return this.inneriter.internalGetIndex();
        }

        @Override
        public int getOffset() {
            return this.inneriter.getOffset();
        }

        @Override
        public Itr advance(int count) {
            this.inneriter.advance(count);
            return this;
        }

        @Override
        public Itr retract() {
            this.inneriter.retract();
            return this;
        }

        @Override
        public Itr seek(int off) {
            this.inneriter.seek(off);
            return this;
        }
    }
}

