/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.ids.integer;

import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDPair;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBID;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDs;

class IntegerDBIDPair
implements DBIDPair,
IntegerDBIDs {
    public int first;
    public int second;

    protected IntegerDBIDPair(int first, int second) {
        this.first = first;
        this.second = second;
    }

    public String toString() {
        return "Pair(" + this.first + ", " + this.second + ")";
    }

    @Override
    @Deprecated
    public final IntegerDBID getFirst() {
        return new IntegerDBID(this.first);
    }

    @Override
    @Deprecated
    public final IntegerDBID getSecond() {
        return new IntegerDBID(this.second);
    }

    @Override
    @Deprecated
    public DBID get(int i) {
        if (i < 0 || i > 1) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return i == 0 ? this.getFirst() : this.getSecond();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntegerDBIDPair)) {
            return false;
        }
        IntegerDBIDPair other = (IntegerDBIDPair)obj;
        return this.first == other.first && this.second == other.second;
    }

    public final int hashCode() {
        long prime = 2654435761L;
        long result = 1L;
        result = 2654435761L * result + (long)this.first;
        result = 2654435761L * result + (long)this.second;
        return (int)result;
    }

    @Override
    public int size() {
        return 2;
    }

    @Override
    public boolean contains(DBIDRef o) {
        int i = o.internalGetIndex();
        return i == this.first || i == this.second;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public DBIDVar assignVar(int index, DBIDVar var) {
        if (index == 0) {
            if (var instanceof IntegerDBIDVar) {
                ((IntegerDBIDVar)var).internalSetIndex(this.first);
                return var;
            }
            var.set(new IntegerDBID(this.first));
            return var;
        }
        if (index == 1) {
            if (var instanceof IntegerDBIDVar) {
                ((IntegerDBIDVar)var).internalSetIndex(this.second);
                return var;
            }
            var.set(new IntegerDBID(this.second));
            return var;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    @Override
    public ArrayDBIDs slice(int begin, int end) {
        return new Slice(begin, end);
    }

    @Override
    public int binarySearch(DBIDRef key) {
        int v = key.internalGetIndex();
        return v == this.first ? 0 : (v == this.second ? 1 : (v < this.first ? -1 : (v < this.second ? -2 : -3)));
    }

    @Override
    public IntegerDBIDArrayIter iter() {
        return new Itr(this.first, this.second);
    }

    private class Slice
    implements IntegerArrayDBIDs {
        final int begin;
        final int end;

        public Slice(int begin, int end) {
            this.begin = begin;
            this.end = end;
        }

        @Override
        public int size() {
            return this.end - this.begin;
        }

        @Override
        public boolean contains(DBIDRef o) {
            int oid = o.internalGetIndex();
            return this.begin == 0 && this.end > 0 && IntegerDBIDPair.this.first == oid || this.begin <= 1 && this.end > 1 && IntegerDBIDPair.this.second == oid;
        }

        @Override
        public boolean isEmpty() {
            return this.begin == this.end;
        }

        @Override
        public DBID get(int i) {
            return IntegerDBIDPair.this.get(this.begin + i);
        }

        @Override
        public DBIDVar assignVar(int index, DBIDVar var) {
            return IntegerDBIDPair.this.assignVar(this.begin + index, var);
        }

        @Override
        public int binarySearch(DBIDRef key) {
            return IntegerDBIDPair.this.binarySearch(key) - this.begin;
        }

        @Override
        public IntegerDBIDArrayIter iter() {
            return new SliceItr();
        }

        @Override
        public Slice slice(int begin, int end) {
            return new Slice(this.begin + begin, this.begin + end);
        }

        private class SliceItr
        implements IntegerDBIDArrayIter {
            int pos;

            private SliceItr() {
                this.pos = Slice.this.begin;
            }

            @Override
            public int internalGetIndex() {
                if (this.pos < 0 || this.pos > 1) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                return this.pos == 0 ? IntegerDBIDPair.this.first : IntegerDBIDPair.this.second;
            }

            @Override
            public boolean valid() {
                return this.pos < Slice.this.end && this.pos >= Slice.this.begin;
            }

            @Override
            public SliceItr advance() {
                ++this.pos;
                return this;
            }

            @Override
            public int getOffset() {
                return this.pos - Slice.this.begin;
            }

            @Override
            public SliceItr advance(int count) {
                this.pos += count;
                return this;
            }

            @Override
            public SliceItr retract() {
                --this.pos;
                return this;
            }

            @Override
            public SliceItr seek(int off) {
                this.pos = Slice.this.begin + off;
                return this;
            }

            public String toString() {
                return Integer.toString(this.internalGetIndex()) + "@" + this.pos;
            }
        }
    }

    private static class Itr
    implements IntegerDBIDArrayIter {
        int first;
        int second;
        int pos;

        public Itr(int first, int second) {
            this.first = first;
            this.second = second;
            this.pos = 0;
        }

        @Override
        public boolean valid() {
            return this.pos < 2;
        }

        @Override
        public Itr advance() {
            ++this.pos;
            return this;
        }

        @Override
        public int internalGetIndex() {
            return this.pos == 0 ? this.first : this.second;
        }

        @Override
        public int getOffset() {
            return this.pos;
        }

        @Override
        public DBIDArrayIter advance(int count) {
            return null;
        }

        @Override
        public DBIDArrayIter retract() {
            --this.pos;
            return this;
        }

        @Override
        public DBIDArrayIter seek(int off) {
            this.pos = off;
            return this;
        }
    }
}

