/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.ids.integer;

import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDFactory;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRange;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.SetDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDs;

final class IntegerDBIDRange
implements IntegerDBIDs,
DBIDRange,
SetDBIDs {
    protected final int start;
    protected final int len;

    protected IntegerDBIDRange(int start, int len) {
        this.start = start;
        this.len = len;
    }

    @Override
    public int size() {
        return this.len;
    }

    @Override
    public boolean contains(DBIDRef o) {
        int oid = o.internalGetIndex();
        if (oid < this.start) {
            return false;
        }
        return oid < this.start + this.len;
    }

    @Override
    public DBID get(int i) {
        if (i > this.len || i < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return DBIDFactory.FACTORY.importInteger(this.start + i);
    }

    @Override
    public int getOffset(DBIDRef dbid) {
        return dbid.internalGetIndex() - this.start;
    }

    @Override
    public DBIDVar assignVar(int index, DBIDVar var) {
        if (var instanceof IntegerDBIDVar) {
            ((IntegerDBIDVar)var).internalSetIndex(this.start + index);
            return var;
        }
        var.set(this.get(index));
        return var;
    }

    @Override
    public int binarySearch(DBIDRef key) {
        int keyid = DBIDUtil.asInteger(key);
        if (keyid < this.start) {
            return -1;
        }
        int off = keyid - this.start;
        if (off < this.len) {
            return off;
        }
        return -(this.len + 1);
    }

    public String toString() {
        return "[" + this.start + " to " + (this.start + this.len - 1) + "]";
    }

    @Override
    public int mapDBIDToOffset(DBIDRef dbid) {
        return dbid.internalGetIndex() - this.start;
    }

    @Override
    public ArrayDBIDs slice(int begin, int end) {
        return new IntegerDBIDRange(begin + this.start, end - begin);
    }

    @Override
    public Itr iter() {
        return new Itr(this.start, this.len);
    }

    private static final class Itr
    implements IntegerDBIDArrayIter {
        private int pos;
        private final int len;
        private final int start;

        public Itr(int start, int len) {
            this.start = start;
            this.len = len;
        }

        @Override
        public boolean valid() {
            return this.pos < this.len && this.pos >= 0;
        }

        @Override
        public Itr advance() {
            ++this.pos;
            return this;
        }

        @Override
        public Itr advance(int count) {
            this.pos += count;
            return this;
        }

        @Override
        public Itr retract() {
            --this.pos;
            return this;
        }

        @Override
        public Itr seek(int off) {
            this.pos = off;
            return this;
        }

        @Override
        public int getOffset() {
            return this.pos;
        }

        @Override
        public int internalGetIndex() {
            return this.start + this.pos;
        }

        @Override
        public boolean equals(Object other) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return Integer.toString(this.internalGetIndex());
        }
    }
}

