/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.ids.integer;

import de.lmu.ifi.dbs.elki.database.datastore.DBIDDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBID;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDs;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;

class IntegerDBIDVar
implements DBIDVar,
IntegerDBIDs {
    int id;

    protected IntegerDBIDVar() {
        this.id = Integer.MIN_VALUE;
    }

    protected IntegerDBIDVar(DBIDRef val) {
        this.id = val.internalGetIndex();
    }

    @Override
    public int internalGetIndex() {
        return this.id;
    }

    protected void internalSetIndex(int i) {
        this.id = i;
    }

    @Override
    public DBIDVar set(DBIDRef ref) {
        this.id = ref.internalGetIndex();
        return this;
    }

    @Override
    @Deprecated
    public DBID get(int i) {
        if (i != 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return new IntegerDBID(i);
    }

    @Override
    public int size() {
        return this.id < 0 ? 0 : 1;
    }

    @Override
    public boolean isEmpty() {
        return this.id < 0;
    }

    @Override
    public void unset() {
        this.id = Integer.MIN_VALUE;
    }

    @Override
    public boolean isSet() {
        return this.id != Integer.MIN_VALUE;
    }

    @Override
    public int binarySearch(DBIDRef key) {
        int other = key.internalGetIndex();
        return other == this.id ? 0 : (other < this.id ? -1 : -2);
    }

    @Override
    public boolean contains(DBIDRef o) {
        return this.id == o.internalGetIndex();
    }

    @Override
    public DBIDVar assignVar(int i, DBIDVar var) {
        assert (var instanceof IntegerDBIDVar);
        ((IntegerDBIDVar)var).internalSetIndex(i);
        return var;
    }

    @Override
    public DBIDVar from(DBIDDataStore store, DBIDRef ref) {
        return store.assignVar(ref, this);
    }

    @Override
    public ArrayDBIDs slice(int begin, int end) {
        return begin == 0 && end == 1 ? this : DBIDUtil.EMPTYDBIDS;
    }

    public String toString() {
        return this.id != Integer.MIN_VALUE ? Integer.toString(this.id) : "null";
    }

    @Override
    public Itr iter() {
        return new Itr();
    }

    protected class Itr
    implements IntegerDBIDArrayIter,
    IntegerDBIDRef {
        int pos = 0;

        protected Itr() {
        }

        @Override
        public Itr advance() {
            ++this.pos;
            return this;
        }

        @Override
        public Itr advance(int count) {
            this.pos += count;
            return this;
        }

        @Override
        public Itr retract() {
            --this.pos;
            return this;
        }

        @Override
        public Itr seek(int off) {
            this.pos = off;
            return this;
        }

        @Override
        public int getOffset() {
            return this.pos;
        }

        @Override
        public int internalGetIndex() {
            return IntegerDBIDVar.this.id;
        }

        @Override
        public boolean valid() {
            return this.pos == 0;
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }

        @Override
        public boolean equals(Object other) {
            if (other instanceof DBID) {
                LoggingUtil.warning("Programming error detected: DBIDItr.equals(DBID). Use sameDBID()!", new Throwable());
            }
            return super.equals(other);
        }

        public String toString() {
            return Integer.toString(this.internalGetIndex());
        }
    }
}

