/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.ids.integer;

import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDFactory;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRange;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDRange;
import de.lmu.ifi.dbs.elki.database.ids.integer.SimpleDBIDFactory;
import de.lmu.ifi.dbs.elki.logging.Logging;
import java.util.ArrayList;
import java.util.BitSet;

public class ReusingDBIDFactory
extends SimpleDBIDFactory {
    private static final Logging LOG = Logging.getLogger(ReusingDBIDFactory.class);
    BitSet dynamicUsed = new BitSet();
    int dynamicStart = 0;
    ArrayList<IntegerDBIDRange> returnedAllocations = new ArrayList();

    @Override
    public synchronized DBID generateSingleDBID() {
        this.dynamicStart = this.dynamicUsed.nextClearBit(this.dynamicStart);
        this.dynamicUsed.set(this.dynamicStart);
        return DBIDFactory.FACTORY.importInteger(-(this.dynamicStart + 1));
    }

    @Override
    public synchronized void deallocateSingleDBID(DBIDRef id) {
        int intid = id.internalGetIndex();
        if (intid >= 0) {
            LOG.warning("Single DBID returned is from a range allocation!");
            return;
        }
        int pos = -intid - 1;
        this.dynamicUsed.clear(pos);
        this.dynamicStart = Math.min(this.dynamicStart, pos);
    }

    @Override
    public synchronized DBIDRange generateStaticDBIDRange(int size) {
        IntegerDBIDRange alloc;
        int i;
        for (i = 0; i < this.returnedAllocations.size(); ++i) {
            alloc = this.returnedAllocations.get(i);
            if (alloc.size() != size) continue;
            this.returnedAllocations.remove(i);
            return alloc;
        }
        for (i = 0; i < this.returnedAllocations.size(); ++i) {
            alloc = this.returnedAllocations.get(i);
            if (alloc.size() <= size) continue;
            IntegerDBIDRange retalloc = new IntegerDBIDRange(alloc.start, size);
            alloc = new IntegerDBIDRange(alloc.start + size, alloc.size() - size);
            this.returnedAllocations.set(i, alloc);
            return retalloc;
        }
        return super.generateStaticDBIDRange(size);
    }

    @Override
    public synchronized void deallocateDBIDRange(DBIDRange range) {
        this.returnedAllocations.add((IntegerDBIDRange)range);
    }
}

