/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.ids.integer;

import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRange;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.integer.AbstractIntegerDBIDFactory;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBID;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDRange;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;

public class SimpleDBIDFactory
extends AbstractIntegerDBIDFactory {
    int dynamicids = 0;
    int rangestart = 0;

    @Override
    public synchronized DBID generateSingleDBID() {
        --this.dynamicids;
        if (this.dynamicids == Integer.MIN_VALUE) {
            throw new AbortException("DBID range allocation error - too many objects allocated!");
        }
        return new IntegerDBID(this.dynamicids);
    }

    @Override
    public void deallocateSingleDBID(DBIDRef id) {
    }

    @Override
    public synchronized DBIDRange generateStaticDBIDRange(int size) {
        if (this.rangestart >= Integer.MAX_VALUE - size) {
            throw new AbortException("DBID range allocation error - too many objects allocated!");
        }
        IntegerDBIDRange alloc = new IntegerDBIDRange(this.rangestart, size);
        this.rangestart += size;
        return alloc;
    }

    @Override
    public DBIDRange generateStaticDBIDRange(int begin, int size) {
        if (begin + size >= Integer.MAX_VALUE) {
            throw new AbortException("DBID range allocation error - too many objects allocated!");
        }
        IntegerDBIDRange alloc = new IntegerDBIDRange(begin, size);
        this.rangestart = Math.max(this.rangestart, begin + size);
        return alloc;
    }

    @Override
    public void deallocateDBIDRange(DBIDRange range) {
    }
}

