/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.ids.integer;

import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRange;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.integer.AbstractIntegerDBIDFactory;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBID;
import de.lmu.ifi.dbs.elki.database.ids.integer.IntegerDBIDRange;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import java.util.concurrent.atomic.AtomicInteger;

public final class TrivialDBIDFactory
extends AbstractIntegerDBIDFactory {
    AtomicInteger next = new AtomicInteger(1);

    @Override
    public DBID generateSingleDBID() {
        int id = this.next.getAndIncrement();
        if (id == Integer.MAX_VALUE) {
            throw new AbortException("DBID allocation error - too many objects allocated!");
        }
        IntegerDBID ret = new IntegerDBID(id);
        return ret;
    }

    @Override
    public void deallocateSingleDBID(DBIDRef id) {
    }

    @Override
    public DBIDRange generateStaticDBIDRange(int size) {
        int start = this.next.getAndAdd(size);
        if (start > this.next.get()) {
            throw new AbortException("DBID range allocation error - too many objects allocated!");
        }
        IntegerDBIDRange alloc = new IntegerDBIDRange(start, size);
        return alloc;
    }

    @Override
    public DBIDRange generateStaticDBIDRange(int begin, int size) {
        int v;
        int end = begin + size;
        if (end > Integer.MAX_VALUE) {
            throw new AbortException("DBID range allocation error - too many objects allocated!");
        }
        IntegerDBIDRange alloc = new IntegerDBIDRange(begin, size);
        while ((v = this.next.get()) < end && !this.next.compareAndSet(v, end)) {
        }
        return alloc;
    }

    @Override
    public void deallocateDBIDRange(DBIDRange range) {
    }
}

