/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.query.distance;

import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.PrimitiveDistanceFunction;

public class PrimitiveDistanceQuery<O>
implements DistanceQuery<O> {
    protected final Relation<? extends O> relation;
    protected final PrimitiveDistanceFunction<? super O> distanceFunction;

    public PrimitiveDistanceQuery(Relation<? extends O> relation, PrimitiveDistanceFunction<? super O> distanceFunction) {
        this.relation = relation;
        this.distanceFunction = distanceFunction;
    }

    @Override
    public final double distance(DBIDRef id1, DBIDRef id2) {
        return this.distance(this.relation.get(id1), this.relation.get(id2));
    }

    @Override
    public final double distance(O o1, DBIDRef id2) {
        return this.distance(o1, this.relation.get(id2));
    }

    @Override
    public final double distance(DBIDRef id1, O o2) {
        return this.distance(this.relation.get(id1), o2);
    }

    @Override
    public double distance(O o1, O o2) {
        return this.distanceFunction.distance(o1, o2);
    }

    @Override
    public Relation<? extends O> getRelation() {
        return this.relation;
    }

    @Override
    public PrimitiveDistanceFunction<? super O> getDistanceFunction() {
        return this.distanceFunction;
    }
}

