/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.query.knn;

import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.LinearScanQuery;
import de.lmu.ifi.dbs.elki.database.query.distance.PrimitiveDistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.AbstractDistanceKNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.PrimitiveDistanceFunction;
import java.util.ArrayList;
import java.util.List;

public class LinearScanPrimitiveDistanceKNNQuery<O>
extends AbstractDistanceKNNQuery<O>
implements LinearScanQuery {
    private PrimitiveDistanceFunction<? super O> rawdist;

    public LinearScanPrimitiveDistanceKNNQuery(PrimitiveDistanceQuery<O> distanceQuery) {
        super(distanceQuery);
        this.rawdist = distanceQuery.getDistanceFunction();
    }

    @Override
    public KNNList getKNNForDBID(DBIDRef id, int k) {
        Relation relation = this.getRelation();
        return this.linearScan(relation, relation.iterDBIDs(), relation.get(id), DBIDUtil.newHeap(k)).toKNNList();
    }

    @Override
    public KNNList getKNNForObject(O obj, int k) {
        Relation relation = this.getRelation();
        return this.linearScan(relation, relation.iterDBIDs(), obj, DBIDUtil.newHeap(k)).toKNNList();
    }

    private KNNHeap linearScan(Relation<? extends O> relation, DBIDIter iter, O obj, KNNHeap heap) {
        PrimitiveDistanceFunction<O> rawdist = this.rawdist;
        double max = Double.POSITIVE_INFINITY;
        while (iter.valid()) {
            double dist = rawdist.distance(obj, relation.get(iter));
            if (dist <= max) {
                max = heap.insert(dist, iter);
            }
            iter.advance();
        }
        return heap;
    }

    @Override
    public List<KNNList> getKNNForBulkDBIDs(ArrayDBIDs ids, int k) {
        Relation relation = this.getRelation();
        int size = ids.size();
        ArrayList<KNNHeap> heaps = new ArrayList<KNNHeap>(size);
        ArrayList objs = new ArrayList(size);
        DBIDArrayIter iter = ids.iter();
        while (iter.valid()) {
            heaps.add(DBIDUtil.newHeap(k));
            objs.add(relation.get(iter));
            iter.advance();
        }
        this.linearScanBatchKNN(objs, heaps);
        ArrayList<KNNList> result = new ArrayList<KNNList>(heaps.size());
        for (KNNHeap heap : heaps) {
            result.add(heap.toKNNList());
        }
        return result;
    }

    protected void linearScanBatchKNN(List<O> objs, List<KNNHeap> heaps) {
        PrimitiveDistanceFunction<O> rawdist = this.rawdist;
        Relation relation = this.getRelation();
        int size = objs.size();
        DBIDIter iter = relation.getDBIDs().iter();
        while (iter.valid()) {
            Object candidate = relation.get(iter);
            for (int index = 0; index < size; ++index) {
                KNNHeap heap = heaps.get(index);
                double dist = rawdist.distance(objs.get(index), candidate);
                if (!(dist <= heap.getKNNDistance())) continue;
                heap.insert(dist, iter);
            }
            iter.advance();
        }
    }
}

