/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.query.knn;

import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.index.preprocessed.knn.AbstractMaterializeKNNPreprocessor;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import java.util.ArrayList;
import java.util.List;

public class PreprocessorKNNQuery<O>
implements KNNQuery<O> {
    private static final Logging LOG = Logging.getLogger(PreprocessorKNNQuery.class);
    protected final Relation<? extends O> relation;
    private final AbstractMaterializeKNNPreprocessor<O> preprocessor;
    private boolean warned = false;

    public PreprocessorKNNQuery(Relation<? extends O> relation, AbstractMaterializeKNNPreprocessor<O> preprocessor) {
        this.relation = relation;
        this.preprocessor = preprocessor;
    }

    @Override
    public KNNList getKNNForDBID(DBIDRef id, int k) {
        if (!this.warned && k > this.preprocessor.getK()) {
            this.getLogger().warning("Requested more neighbors than preprocessed: requested " + k + " preprocessed " + this.preprocessor.getK(), new Throwable());
            this.warned = true;
        }
        return this.preprocessor.get(id).subList(k);
    }

    @Override
    public List<KNNList> getKNNForBulkDBIDs(ArrayDBIDs ids, int k) {
        if (!this.warned && k > this.preprocessor.getK()) {
            this.getLogger().warning("Requested more neighbors than preprocessed: requested " + k + " preprocessed " + this.preprocessor.getK(), new Throwable());
            this.warned = true;
        }
        if (k < this.preprocessor.getK()) {
            ArrayList<KNNList> result = new ArrayList<KNNList>(ids.size());
            DBIDArrayIter iter = ids.iter();
            while (iter.valid()) {
                result.add(this.preprocessor.get(iter).subList(k));
                iter.advance();
            }
            return result;
        }
        ArrayList<KNNList> result = new ArrayList<KNNList>(ids.size());
        DBIDArrayIter iter = ids.iter();
        while (iter.valid()) {
            result.add(this.preprocessor.get(iter));
            iter.advance();
        }
        return result;
    }

    @Override
    public KNNList getKNNForObject(O obj, int k) {
        throw new AbortException("Preprocessor KNN query only supports ID queries.");
    }

    public AbstractMaterializeKNNPreprocessor<O> getPreprocessor() {
        return this.preprocessor;
    }

    protected Logging getLogger() {
        return LOG;
    }
}

