/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.query.range;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.distance.PrimitiveDistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.range.LinearScanPrimitiveDistanceRangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.SquaredEuclideanDistanceFunction;
import net.jafama.FastMath;

public class LinearScanEuclideanDistanceRangeQuery<O extends NumberVector>
extends LinearScanPrimitiveDistanceRangeQuery<O> {
    public LinearScanEuclideanDistanceRangeQuery(PrimitiveDistanceQuery<O> distanceQuery) {
        super(distanceQuery);
    }

    @Override
    public DoubleDBIDList getRangeForDBID(DBIDRef id, double range) {
        Relation relation = this.getRelation();
        NumberVector obj = (NumberVector)relation.get(id);
        ModifiableDoubleDBIDList result = DBIDUtil.newDistanceDBIDList();
        this.linearScan(relation, relation.iterDBIDs(), obj, range, result);
        result.sort();
        return result;
    }

    @Override
    public DoubleDBIDList getRangeForObject(O obj, double range) {
        Relation relation = this.getRelation();
        ModifiableDoubleDBIDList result = DBIDUtil.newDistanceDBIDList();
        this.linearScan(relation, relation.iterDBIDs(), obj, range, result);
        result.sort();
        return result;
    }

    @Override
    public void getRangeForDBID(DBIDRef id, double range, ModifiableDoubleDBIDList neighbors) {
        Relation relation = this.getRelation();
        this.linearScan(relation, relation.iterDBIDs(), (NumberVector)relation.get(id), range, neighbors);
    }

    @Override
    public void getRangeForObject(O obj, double range, ModifiableDoubleDBIDList neighbors) {
        Relation relation = this.getRelation();
        this.linearScan(relation, relation.iterDBIDs(), obj, range, neighbors);
    }

    private void linearScan(Relation<? extends O> relation, DBIDIter iter, O obj, double range, ModifiableDoubleDBIDList result) {
        SquaredEuclideanDistanceFunction squared = SquaredEuclideanDistanceFunction.STATIC;
        double upper = range * 1.0000001;
        double sqrange = upper * upper;
        while (iter.valid()) {
            double dist;
            double sqdistance = squared.distance((NumberVector)obj, (NumberVector)relation.get(iter));
            if (sqdistance <= sqrange && (dist = FastMath.sqrt(sqdistance)) <= range) {
                result.add(dist, iter);
            }
            iter.advance();
        }
    }
}

