/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.query.range;

import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.range.AbstractSimilarityRangeQuery;
import de.lmu.ifi.dbs.elki.database.query.similarity.PrimitiveSimilarityQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.PrimitiveSimilarityFunction;

public class LinearScanPrimitiveSimilarityRangeQuery<O>
extends AbstractSimilarityRangeQuery<O> {
    private PrimitiveSimilarityFunction<? super O> rawsim;

    public LinearScanPrimitiveSimilarityRangeQuery(PrimitiveSimilarityQuery<O> similarityQuery) {
        super(similarityQuery);
        this.rawsim = similarityQuery.getSimilarityFunction();
    }

    @Override
    public DoubleDBIDList getRangeForDBID(DBIDRef id, double range) {
        Object obj = this.relation.get(id);
        ModifiableDoubleDBIDList result = DBIDUtil.newDistanceDBIDList();
        this.linearScan(this.relation, this.relation.iterDBIDs(), obj, range, result);
        result.sort();
        return result;
    }

    @Override
    public DoubleDBIDList getRangeForObject(O obj, double range) {
        ModifiableDoubleDBIDList result = DBIDUtil.newDistanceDBIDList();
        this.linearScan(this.relation, this.relation.iterDBIDs(), obj, range, result);
        result.sort();
        return result;
    }

    @Override
    public void getRangeForDBID(DBIDRef id, double range, ModifiableDoubleDBIDList neighbors) {
        this.linearScan(this.relation, this.relation.iterDBIDs(), this.relation.get(id), range, neighbors);
    }

    @Override
    public void getRangeForObject(O obj, double range, ModifiableDoubleDBIDList neighbors) {
        this.linearScan(this.relation, this.relation.iterDBIDs(), obj, range, neighbors);
    }

    private void linearScan(Relation<? extends O> relation, DBIDIter iter, O obj, double range, ModifiableDoubleDBIDList result) {
        while (iter.valid()) {
            double similarity = this.rawsim.similarity(obj, relation.get(iter));
            if (similarity >= range) {
                result.add(similarity, iter);
            }
            iter.advance();
        }
    }
}

