/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.query.range;

import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.LinearScanQuery;
import de.lmu.ifi.dbs.elki.database.query.range.AbstractSimilarityRangeQuery;
import de.lmu.ifi.dbs.elki.database.query.similarity.SimilarityQuery;

public class LinearScanSimilarityRangeQuery<O>
extends AbstractSimilarityRangeQuery<O>
implements LinearScanQuery {
    public LinearScanSimilarityRangeQuery(SimilarityQuery<O> simQuery) {
        super(simQuery);
    }

    @Override
    public DoubleDBIDList getRangeForDBID(DBIDRef id, double range) {
        ModifiableDoubleDBIDList result = DBIDUtil.newDistanceDBIDList();
        DBIDIter iter = this.relation.getDBIDs().iter();
        while (iter.valid()) {
            double currentSim = this.simQuery.similarity(id, (DBIDRef)iter);
            if (currentSim >= range) {
                result.add(currentSim, iter);
            }
            iter.advance();
        }
        result.sort();
        return result;
    }

    @Override
    public DoubleDBIDList getRangeForObject(O obj, double range) {
        ModifiableDoubleDBIDList result = DBIDUtil.newDistanceDBIDList();
        DBIDIter iter = this.relation.getDBIDs().iter();
        while (iter.valid()) {
            double currentSim = this.simQuery.similarity(obj, iter);
            if (currentSim >= range) {
                result.add(currentSim, iter);
            }
            iter.advance();
        }
        result.sort();
        return result;
    }

    @Override
    public void getRangeForDBID(DBIDRef id, double range, ModifiableDoubleDBIDList neighbors) {
        DBIDIter iter = this.relation.iterDBIDs();
        while (iter.valid()) {
            double currentSim = this.simQuery.similarity(id, (DBIDRef)iter);
            if (currentSim >= range) {
                neighbors.add(currentSim, iter);
            }
            iter.advance();
        }
    }

    @Override
    public void getRangeForObject(O obj, double range, ModifiableDoubleDBIDList neighbors) {
        DBIDIter iter = this.relation.iterDBIDs();
        while (iter.valid()) {
            double currentSim = this.simQuery.similarity(obj, iter);
            if (currentSim >= range) {
                neighbors.add(currentSim, iter);
            }
            iter.advance();
        }
    }
}

