/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.query.rknn;

import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.LinearScanQuery;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.rknn.AbstractRKNNQuery;
import java.util.ArrayList;
import java.util.List;

public class LinearScanRKNNQuery<O>
extends AbstractRKNNQuery<O>
implements LinearScanQuery {
    protected final KNNQuery<O> knnQuery;

    public LinearScanRKNNQuery(DistanceQuery<O> distanceQuery, KNNQuery<O> knnQuery, Integer maxk) {
        super(distanceQuery);
        this.knnQuery = knnQuery;
    }

    @Override
    public DoubleDBIDList getRKNNForObject(O obj, int k) {
        ModifiableDoubleDBIDList rNNlist = DBIDUtil.newDistanceDBIDList();
        ArrayDBIDs allIDs = DBIDUtil.ensureArray(this.relation.getDBIDs());
        List<KNNList> kNNLists = this.knnQuery.getKNNForBulkDBIDs(allIDs, k);
        DBIDArrayIter iter = allIDs.iter();
        while (iter.valid()) {
            KNNList knn = kNNLists.get(iter.getOffset());
            double dist = this.distanceQuery.distance(obj, iter);
            int last = Math.min(k - 1, knn.size() - 1);
            if (last < k - 1 || dist <= knn.doubleValue(last)) {
                rNNlist.add(dist, iter);
            }
            iter.advance();
        }
        rNNlist.sort();
        return rNNlist;
    }

    @Override
    public DoubleDBIDList getRKNNForDBID(DBIDRef id, int k) {
        ModifiableDoubleDBIDList rNNList = DBIDUtil.newDistanceDBIDList();
        ArrayDBIDs allIDs = DBIDUtil.ensureArray(this.relation.getDBIDs());
        List<KNNList> kNNList = this.knnQuery.getKNNForBulkDBIDs(allIDs, k);
        int i = 0;
        DBIDArrayIter iter = allIDs.iter();
        while (iter.valid()) {
            KNNList knn = kNNList.get(i);
            DoubleDBIDListIter n = knn.iter();
            while (n.valid()) {
                if (DBIDUtil.equal(n, id)) {
                    rNNList.add(n.doubleValue(), iter);
                }
                n.advance();
            }
            ++i;
            iter.advance();
        }
        rNNList.sort();
        return rNNList;
    }

    @Override
    public List<? extends DoubleDBIDList> getRKNNForBulkDBIDs(ArrayDBIDs ids, int k) {
        ArrayList<ModifiableDoubleDBIDList> rNNList = new ArrayList<ModifiableDoubleDBIDList>(ids.size());
        for (int i = 0; i < ids.size(); ++i) {
            rNNList.add(DBIDUtil.newDistanceDBIDList());
        }
        ArrayDBIDs allIDs = DBIDUtil.ensureArray(this.relation.getDBIDs());
        List<KNNList> kNNList = this.knnQuery.getKNNForBulkDBIDs(allIDs, k);
        int i = 0;
        DBIDArrayIter iter = allIDs.iter();
        while (iter.valid()) {
            KNNList knn = kNNList.get(i);
            DoubleDBIDListIter n = knn.iter();
            while (n.valid()) {
                int j = 0;
                DBIDArrayIter iter2 = ids.iter();
                while (iter2.valid()) {
                    if (DBIDUtil.equal(n, iter2)) {
                        ModifiableDoubleDBIDList rNN = (ModifiableDoubleDBIDList)rNNList.get(j);
                        rNN.add(n.doubleValue(), iter);
                    }
                    ++j;
                    iter2.advance();
                }
                n.advance();
            }
            ++i;
            iter.advance();
        }
        for (int j = 0; j < ids.size(); ++j) {
            ((ModifiableDoubleDBIDList)rNNList.get(j)).sort();
        }
        return rNNList;
    }
}

