/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.query.rknn;

import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.rknn.RKNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.index.preprocessed.knn.MaterializeKNNAndRKNNPreprocessor;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import java.util.ArrayList;
import java.util.List;

public class PreprocessorRKNNQuery<O>
implements RKNNQuery<O> {
    protected final Relation<? extends O> relation;
    private final MaterializeKNNAndRKNNPreprocessor<O> preprocessor;
    private boolean warned = false;

    public PreprocessorRKNNQuery(Relation<O> relation, MaterializeKNNAndRKNNPreprocessor<O> preprocessor) {
        this.relation = relation;
        this.preprocessor = preprocessor;
    }

    public PreprocessorRKNNQuery(Relation<O> database, MaterializeKNNAndRKNNPreprocessor.Factory<O> preprocessor) {
        this(database, (MaterializeKNNAndRKNNPreprocessor<O>)preprocessor.instantiate((Relation)database));
    }

    @Override
    public DoubleDBIDList getRKNNForDBID(DBIDRef id, int k) {
        if (!this.warned && k != this.preprocessor.getK()) {
            LoggingUtil.warning("Requested more neighbors than preprocessed!");
        }
        return this.preprocessor.getRKNN(id);
    }

    @Override
    public DoubleDBIDList getRKNNForObject(O obj, int k) {
        throw new AbortException("Preprocessor KNN query only supports ID queries.");
    }

    @Override
    public List<? extends DoubleDBIDList> getRKNNForBulkDBIDs(ArrayDBIDs ids, int k) {
        if (!this.warned && k != this.preprocessor.getK()) {
            LoggingUtil.warning("Requested more neighbors than preprocessed!");
        }
        ArrayList<DoubleDBIDList> result = new ArrayList<DoubleDBIDList>(ids.size());
        DBIDArrayIter iter = ids.iter();
        while (iter.valid()) {
            result.add(this.preprocessor.getRKNN(iter));
            iter.advance();
        }
        return result;
    }
}

