/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.relation;

import de.lmu.ifi.dbs.elki.database.QueryUtil;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.query.rknn.LinearScanRKNNQuery;
import de.lmu.ifi.dbs.elki.database.query.rknn.RKNNQuery;
import de.lmu.ifi.dbs.elki.database.query.similarity.SimilarityQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DBIDDistanceFunction;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.DBIDSimilarityFunction;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.SimilarityFunction;
import de.lmu.ifi.dbs.elki.index.DistanceIndex;
import de.lmu.ifi.dbs.elki.index.KNNIndex;
import de.lmu.ifi.dbs.elki.index.RKNNIndex;
import de.lmu.ifi.dbs.elki.index.RangeIndex;
import de.lmu.ifi.dbs.elki.index.SimilarityIndex;
import de.lmu.ifi.dbs.elki.index.SimilarityRangeIndex;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.AbstractHierarchicalResult;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.It;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;

public abstract class AbstractRelation<O>
extends AbstractHierarchicalResult
implements Relation<O> {
    @Override
    public DistanceQuery<O> getDistanceQuery(DistanceFunction<? super O> distanceFunction, Object ... hints) {
        if (distanceFunction == null) {
            throw new AbortException("Distance query requested for 'null' distance!");
        }
        It<DistanceIndex> it = this.getHierarchy().iterChildrenReverse(this).filter(DistanceIndex.class);
        while (it.valid()) {
            DistanceQuery<? super O> q = it.get().getDistanceQuery(distanceFunction, hints);
            if (this.getLogger().isDebuggingFinest()) {
                this.getLogger().debugFinest((q != null ? "Using" : "Not using") + " index for distance query: " + it.get());
            }
            if (q != null) {
                return q;
            }
            it.advance();
        }
        for (Object o : hints) {
            if (o != "optimized" || distanceFunction instanceof DBIDDistanceFunction) continue;
            return null;
        }
        return distanceFunction.instantiate(this);
    }

    @Override
    public SimilarityQuery<O> getSimilarityQuery(SimilarityFunction<? super O> similarityFunction, Object ... hints) {
        if (similarityFunction == null) {
            throw new AbortException("Similarity query requested for 'null' similarity!");
        }
        It<SimilarityIndex> it = this.getHierarchy().iterChildrenReverse(this).filter(SimilarityIndex.class);
        while (it.valid()) {
            SimilarityQuery<? super O> q = it.get().getSimilarityQuery(similarityFunction, hints);
            if (this.getLogger().isDebuggingFinest()) {
                this.getLogger().debugFinest((q != null ? "Using" : "Not using") + " index for similarity query: " + it.get());
            }
            if (q != null) {
                return q;
            }
            it.advance();
        }
        for (Object o : hints) {
            if (o != "optimized" || similarityFunction instanceof DBIDSimilarityFunction) continue;
            return null;
        }
        return similarityFunction.instantiate(this);
    }

    @Override
    public KNNQuery<O> getKNNQuery(DistanceQuery<O> distanceQuery, Object ... hints) {
        if (distanceQuery == null) {
            throw new AbortException("kNN query requested for 'null' distance!");
        }
        Object[] it = this.getHierarchy().iterChildrenReverse(this).filter(KNNIndex.class);
        while (it.valid()) {
            KNNQuery<O> q = it.get().getKNNQuery(distanceQuery, hints);
            if (this.getLogger().isDebuggingFinest()) {
                this.getLogger().debugFinest((q != null ? "Using" : "Not using") + " index for kNN query: " + it.get());
            }
            if (q != null) {
                return q;
            }
            it.advance();
        }
        for (Object hint : hints) {
            if (hint != "optimized") continue;
            return null;
        }
        if (this.getLogger().isDebuggingFinest()) {
            StringBuilder buf = new StringBuilder();
            buf.append("Fallback to linear scan - no index was able to accelerate this query.\n");
            buf.append("Distance query: ").append(distanceQuery).append('\n');
            if (hints.length > 0) {
                buf.append("Hints:");
                for (Object o : hints) {
                    buf.append(' ').append(o);
                }
            }
            this.getLogger().debugFinest(buf.toString());
        }
        return QueryUtil.getLinearScanKNNQuery(distanceQuery);
    }

    @Override
    public RangeQuery<O> getRangeQuery(DistanceQuery<O> distanceQuery, Object ... hints) {
        if (distanceQuery == null) {
            throw new AbortException("Range query requested for 'null' distance!");
        }
        Object[] it = this.getHierarchy().iterChildrenReverse(this).filter(RangeIndex.class);
        while (it.valid()) {
            RangeQuery<O> q = it.get().getRangeQuery(distanceQuery, hints);
            if (this.getLogger().isDebuggingFinest()) {
                this.getLogger().debugFinest((q != null ? "Using" : "Not using") + " index for range query: " + it.get());
            }
            if (q != null) {
                return q;
            }
            it.advance();
        }
        for (Object hint : hints) {
            if (hint != "optimized") continue;
            return null;
        }
        if (this.getLogger().isDebuggingFinest()) {
            StringBuilder buf = new StringBuilder();
            buf.append("Fallback to linear scan - no index was able to accelerate this query.\n");
            buf.append("Distance query: ").append(distanceQuery).append('\n');
            if (hints.length > 0) {
                buf.append("Hints:");
                for (Object o : hints) {
                    buf.append(' ').append(o);
                }
            }
            this.getLogger().debugFinest(buf.toString());
        }
        return QueryUtil.getLinearScanRangeQuery(distanceQuery);
    }

    @Override
    public RangeQuery<O> getSimilarityRangeQuery(SimilarityQuery<O> simQuery, Object ... hints) {
        if (simQuery == null) {
            throw new AbortException("Range query requested for 'null' distance!");
        }
        Object[] it = this.getHierarchy().iterChildrenReverse(this).filter(SimilarityRangeIndex.class);
        while (it.valid()) {
            RangeQuery<O> q = it.get().getSimilarityRangeQuery(simQuery, hints);
            if (this.getLogger().isDebuggingFinest()) {
                this.getLogger().debugFinest((q != null ? "Using" : "Not using") + " index for range query: " + it.get());
            }
            if (q != null) {
                return q;
            }
            it.advance();
        }
        for (Object hint : hints) {
            if (hint != "optimized") continue;
            return null;
        }
        if (this.getLogger().isDebuggingFinest()) {
            StringBuilder buf = new StringBuilder();
            buf.append("Fallback to linear scan - no index was able to accelerate this query.\n");
            buf.append("Distance query: ").append(simQuery).append('\n');
            if (hints.length > 0) {
                buf.append("Hints:");
                for (Object o : hints) {
                    buf.append(' ').append(o);
                }
            }
            this.getLogger().debugFinest(buf.toString());
        }
        return QueryUtil.getLinearScanSimilarityRangeQuery(simQuery);
    }

    @Override
    public RKNNQuery<O> getRKNNQuery(DistanceQuery<O> distanceQuery, Object ... hints) {
        if (distanceQuery == null) {
            throw new AbortException("RKNN query requested for 'null' distance!");
        }
        It<RKNNIndex> it = this.getHierarchy().iterChildrenReverse(this).filter(RKNNIndex.class);
        while (it.valid()) {
            RKNNQuery<O> rKNNQuery = it.get().getRKNNQuery(distanceQuery, hints);
            if (this.getLogger().isDebuggingFinest()) {
                this.getLogger().debugFinest((rKNNQuery != null ? "Using" : "Not using") + " index for RkNN query: " + it.get());
            }
            if (rKNNQuery != null) {
                return rKNNQuery;
            }
            it.advance();
        }
        Integer maxk = null;
        for (Object hint : hints) {
            if (hint == "optimized") {
                return null;
            }
            if (!(hint instanceof Integer)) continue;
            maxk = (Integer)hint;
        }
        if (this.getLogger().isDebuggingFinest()) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Fallback to linear scan - no index was able to accelerate this query.\n");
            stringBuilder.append("Distance query: ").append(distanceQuery).append('\n');
            if (hints.length > 0) {
                stringBuilder.append("Hints:");
                for (Object o : hints) {
                    stringBuilder.append(' ').append(o);
                }
            }
            this.getLogger().debugFinest(stringBuilder.toString());
        }
        KNNQuery<O> kNNQuery = this.getKNNQuery(distanceQuery, "need_bulk", maxk);
        return new LinearScanRKNNQuery<O>(distanceQuery, kNNQuery, maxk);
    }

    protected abstract Logging getLogger();
}

