/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.relation;

import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DoubleDataStore;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.StaticDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.AbstractRelation;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.logging.Logging;

public class MaterializedDoubleRelation
extends AbstractRelation<Double>
implements DoubleRelation {
    private static final Logging LOG = Logging.getLogger(MaterializedDoubleRelation.class);
    private final DoubleDataStore content;
    private final StaticDBIDs ids;
    private String name;
    private String shortname = "relation";

    public MaterializedDoubleRelation(DBIDs ids) {
        this(ids, null);
    }

    public MaterializedDoubleRelation(DBIDs ids, String name) {
        this(ids, name, DataStoreUtil.makeDoubleStorage(ids, 30));
    }

    public MaterializedDoubleRelation(DBIDs ids, String name, DoubleDataStore content) {
        this.ids = DBIDUtil.makeUnmodifiable(ids);
        this.name = name;
        this.content = content;
    }

    public MaterializedDoubleRelation(String name, String shortname, DoubleDataStore content, DBIDs ids) {
        this.ids = DBIDUtil.makeUnmodifiable(ids);
        this.name = name;
        this.shortname = shortname;
        this.content = content;
    }

    @Override
    public double doubleValue(DBIDRef id) {
        return this.content.doubleValue(id);
    }

    @Override
    public void set(DBIDRef id, double val) {
        assert (this.ids.contains(id));
        if (this.content instanceof WritableDoubleDataStore) {
            ((WritableDoubleDataStore)this.content).putDouble(id, val);
        }
    }

    @Override
    @Deprecated
    public void insert(DBIDRef id, Double val) {
        assert (this.ids.contains(id));
        if (this.content instanceof WritableDoubleDataStore) {
            ((WritableDoubleDataStore)this.content).putDouble(id, val);
        }
    }

    @Override
    public void delete(DBIDRef id) {
        assert (!this.ids.contains(id));
        if (this.content instanceof WritableDoubleDataStore) {
            ((WritableDoubleDataStore)this.content).delete(id);
        }
    }

    @Override
    public StaticDBIDs getDBIDs() {
        return this.ids;
    }

    @Override
    public DBIDIter iterDBIDs() {
        return this.ids.iter();
    }

    @Override
    public int size() {
        return this.ids.size();
    }

    @Override
    public SimpleTypeInformation<Double> getDataTypeInformation() {
        return TypeUtil.DOUBLE;
    }

    @Override
    public String getLongName() {
        return this.name != null ? this.name : "Double";
    }

    @Override
    public String getShortName() {
        return this.shortname;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }
}

