/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.relation;

import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.database.datastore.DataStore;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.StaticDBIDs;
import de.lmu.ifi.dbs.elki.database.relation.AbstractRelation;
import de.lmu.ifi.dbs.elki.database.relation.ModifiableRelation;
import de.lmu.ifi.dbs.elki.index.DynamicIndex;
import de.lmu.ifi.dbs.elki.index.Index;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.It;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;

public class MaterializedRelation<O>
extends AbstractRelation<O>
implements ModifiableRelation<O> {
    private static final Logging LOG = Logging.getLogger(MaterializedRelation.class);
    private final SimpleTypeInformation<O> type;
    private final DataStore<O> content;
    private final StaticDBIDs ids;
    private String name;
    private String shortname = "relation";

    public MaterializedRelation(SimpleTypeInformation<O> type, DBIDs ids) {
        this(type, ids, null);
    }

    public MaterializedRelation(SimpleTypeInformation<O> type, DBIDs ids, String name) {
        this.type = type;
        this.ids = DBIDUtil.makeUnmodifiable(ids);
        this.name = name;
        this.content = DataStoreUtil.makeStorage(ids, 30, type.getRestrictionClass());
    }

    public MaterializedRelation(SimpleTypeInformation<O> type, DBIDs ids, String name, DataStore<O> content) {
        this.type = type;
        this.ids = DBIDUtil.makeUnmodifiable(ids);
        this.name = name;
        this.content = content;
    }

    public MaterializedRelation(String name, String shortname, SimpleTypeInformation<O> type, DataStore<O> content, DBIDs ids) {
        this.type = type;
        this.ids = DBIDUtil.makeUnmodifiable(ids);
        this.name = name;
        this.shortname = shortname;
        this.content = content;
    }

    @Override
    public O get(DBIDRef id) {
        return this.content.get(id);
    }

    @Override
    public void insert(DBIDRef id, O val) {
        assert (this.ids.contains(id)) : "Object not yet in DBIDs.";
        if (!(this.content instanceof WritableDataStore)) {
            throw new AbortException("Data is stored in a non-writable data store. Modifications are not possible.");
        }
        ((WritableDataStore)this.content).put(id, val);
        It<Index> it = this.getHierarchy().iterDescendants(this).filter(Index.class);
        while (it.valid()) {
            if (!(it.get() instanceof DynamicIndex)) {
                throw new AbortException("A non-dynamic index was added to this database. Modifications are not allowed, unless this index is removed.");
            }
            ((DynamicIndex)it.get()).insert(id);
            it.advance();
        }
    }

    @Override
    public void delete(DBIDRef id) {
        assert (!this.ids.contains(id)) : "Object still in DBIDs.";
        if (!(this.content instanceof WritableDataStore)) {
            throw new AbortException("Data is stored in a non-writable data store. Modifications are not possible.");
        }
        It<Index> it = this.getHierarchy().iterDescendants(this).filter(Index.class);
        while (it.valid()) {
            if (!(it.get() instanceof DynamicIndex)) {
                throw new AbortException("A non-dynamic index was added to this database. Modifications are not allowed, unless this index is removed.");
            }
            ((DynamicIndex)it.get()).delete(id);
            it.advance();
        }
        ((WritableDataStore)this.content).delete(id);
    }

    @Override
    public StaticDBIDs getDBIDs() {
        return this.ids;
    }

    @Override
    public DBIDIter iterDBIDs() {
        return this.ids.iter();
    }

    @Override
    public int size() {
        return this.ids.size();
    }

    @Override
    public SimpleTypeInformation<O> getDataTypeInformation() {
        return this.type;
    }

    @Override
    public String getLongName() {
        return this.name != null ? this.name : this.type.toString();
    }

    @Override
    public String getShortName() {
        return this.shortname;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }
}

