/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.relation;

import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.DatabaseQuery;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.query.rknn.RKNNQuery;
import de.lmu.ifi.dbs.elki.database.query.similarity.SimilarityQuery;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.distance.similarityfunction.SimilarityFunction;
import de.lmu.ifi.dbs.elki.result.HierarchicalResult;
import java.util.function.BiConsumer;

public interface Relation<O>
extends DatabaseQuery,
HierarchicalResult {
    public O get(DBIDRef var1);

    public SimpleTypeInformation<O> getDataTypeInformation();

    public DBIDs getDBIDs();

    public DBIDIter iterDBIDs();

    public int size();

    default public void forEach(BiConsumer<? super DBIDRef, ? super O> action) {
        DBIDIter it = this.iterDBIDs();
        while (it.valid()) {
            action.accept(it, this.get(it));
            it.advance();
        }
    }

    public DistanceQuery<O> getDistanceQuery(DistanceFunction<? super O> var1, Object ... var2);

    public SimilarityQuery<O> getSimilarityQuery(SimilarityFunction<? super O> var1, Object ... var2);

    public KNNQuery<O> getKNNQuery(DistanceQuery<O> var1, Object ... var2);

    default public KNNQuery<O> getKNNQuery(DistanceFunction<? super O> distanceFunction, Object ... hints) {
        DistanceQuery<? super O> distanceQuery = this.getDistanceQuery(distanceFunction, hints);
        return this.getKNNQuery(distanceQuery, hints);
    }

    public RangeQuery<O> getRangeQuery(DistanceQuery<O> var1, Object ... var2);

    default public RangeQuery<O> getRangeQuery(DistanceFunction<? super O> distanceFunction, Object ... hints) {
        DistanceQuery<? super O> distanceQuery = this.getDistanceQuery(distanceFunction, hints);
        return this.getRangeQuery(distanceQuery, hints);
    }

    public RangeQuery<O> getSimilarityRangeQuery(SimilarityQuery<O> var1, Object ... var2);

    default public RangeQuery<O> getSimilarityRangeQuery(SimilarityFunction<? super O> simFunction, Object ... hints) {
        SimilarityQuery<? super O> simQuery = this.getSimilarityQuery(simFunction, hints);
        return this.getSimilarityRangeQuery(simQuery, hints);
    }

    public RKNNQuery<O> getRKNNQuery(DistanceQuery<O> var1, Object ... var2);

    default public RKNNQuery<O> getRKNNQuery(DistanceFunction<? super O> distanceFunction, Object ... hints) {
        DistanceQuery<? super O> distanceQuery = this.getDistanceQuery(distanceFunction, hints);
        return this.getRKNNQuery(distanceQuery, hints);
    }
}

