/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.relation;

import de.lmu.ifi.dbs.elki.data.FeatureVector;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.type.FieldTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;

public final class RelationUtil {
    private RelationUtil() {
    }

    public static <V extends FeatureVector<?>> VectorFieldTypeInformation<V> assumeVectorField(Relation<V> relation) {
        try {
            return (VectorFieldTypeInformation)relation.getDataTypeInformation();
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("Expected a vector field, got type information: " + relation.getDataTypeInformation().toString(), e);
        }
    }

    public static <V extends NumberVector> NumberVector.Factory<V> getNumberVectorFactory(Relation<V> relation) {
        VectorFieldTypeInformation<V> type = RelationUtil.assumeVectorField(relation);
        NumberVector.Factory factory = (NumberVector.Factory)type.getFactory();
        return factory;
    }

    public static int dimensionality(Relation<? extends SpatialComparable> relation) {
        SimpleTypeInformation<? extends SpatialComparable> type = relation.getDataTypeInformation();
        if (type instanceof FieldTypeInformation) {
            return ((FieldTypeInformation)((Object)type)).getDimensionality();
        }
        return -1;
    }

    public static double[][] computeMinMax(Relation<? extends NumberVector> relation) {
        int dim = RelationUtil.dimensionality(relation);
        double[] mins = new double[dim];
        double[] maxs = new double[dim];
        for (int i = 0; i < dim; ++i) {
            mins[i] = Double.MAX_VALUE;
            maxs[i] = -1.7976931348623157E308;
        }
        DBIDIter iditer = relation.iterDBIDs();
        while (iditer.valid()) {
            NumberVector o = relation.get(iditer);
            for (int d = 0; d < dim; ++d) {
                double v = o.doubleValue(d);
                mins[d] = v < mins[d] ? v : mins[d];
                maxs[d] = v > maxs[d] ? v : maxs[d];
            }
            iditer.advance();
        }
        return new double[][]{mins, maxs};
    }

    public static double[][] relationAsMatrix(Relation<? extends NumberVector> relation, ArrayDBIDs ids) {
        int rowdim = ids.size();
        int coldim = RelationUtil.dimensionality(relation);
        double[][] mat = new double[rowdim][coldim];
        int r = 0;
        DBIDArrayIter iter = ids.iter();
        while (iter.valid()) {
            NumberVector vec = relation.get(iter);
            double[] row = mat[r];
            for (int c = 0; c < coldim; ++c) {
                row[c] = vec.doubleValue(c);
            }
            iter.advance();
            ++r;
        }
        assert (r == rowdim);
        return mat;
    }

    public static <V extends SpatialComparable> String getColumnLabel(Relation<? extends V> rel, int col) {
        SimpleTypeInformation<? extends V> type = rel.getDataTypeInformation();
        if (!(type instanceof VectorFieldTypeInformation)) {
            return "Column " + col;
        }
        VectorFieldTypeInformation vtype = (VectorFieldTypeInformation)type;
        String lbl = vtype.getLabel(col);
        return lbl != null ? lbl : "Column " + col;
    }

    public static <V extends NumberVector, T extends NumberVector> Relation<V> relationUglyVectorCast(Relation<T> database) {
        return database;
    }

    public static class DescendingByDoubleRelation
    implements Comparator<DBIDRef> {
        private final DoubleRelation scores;

        public DescendingByDoubleRelation(DoubleRelation scores) {
            this.scores = scores;
        }

        @Override
        public int compare(DBIDRef id1, DBIDRef id2) {
            return Double.compare(this.scores.doubleValue(id2), this.scores.doubleValue(id1));
        }
    }

    public static class AscendingByDoubleRelation
    implements Comparator<DBIDRef> {
        private final DoubleRelation scores;

        public AscendingByDoubleRelation(DoubleRelation scores) {
            this.scores = scores;
        }

        @Override
        public int compare(DBIDRef id1, DBIDRef id2) {
            return Double.compare(this.scores.doubleValue(id1), this.scores.doubleValue(id2));
        }
    }

    public static class CollectionFromRelation<O>
    extends AbstractCollection<O>
    implements Collection<O> {
        Relation<? extends O> db;

        public CollectionFromRelation(Relation<? extends O> db) {
            this.db = db;
        }

        @Override
        public Iterator<O> iterator() {
            return new RelationObjectIterator<O>(this.db);
        }

        @Override
        public int size() {
            return this.db.size();
        }
    }

    public static class RelationObjectIterator<O>
    implements Iterator<O> {
        final DBIDIter iter;
        final Relation<? extends O> database;

        public RelationObjectIterator(DBIDIter iter, Relation<? extends O> database) {
            this.iter = iter;
            this.database = database;
        }

        public RelationObjectIterator(Relation<? extends O> database) {
            this.database = database;
            this.iter = database.iterDBIDs();
        }

        @Override
        public boolean hasNext() {
            return this.iter.valid();
        }

        @Override
        public O next() {
            O ret = this.database.get(this.iter);
            this.iter.advance();
            return ret;
        }
    }
}

