/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource;

import de.lmu.ifi.dbs.elki.datasource.DatabaseConnection;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleStreamSource;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.datasource.filter.ObjectFilter;
import de.lmu.ifi.dbs.elki.datasource.filter.StreamFilter;
import de.lmu.ifi.dbs.elki.datasource.parser.Parser;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectListParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.util.List;

public abstract class AbstractDatabaseConnection
implements DatabaseConnection {
    public static final String LABEL_CONCATENATION = " ";
    protected List<ObjectFilter> filters;

    protected AbstractDatabaseConnection(List<ObjectFilter> filters) {
        this.filters = filters;
    }

    protected MultipleObjectsBundle invokeBundleFilters(MultipleObjectsBundle bundle) {
        assert (bundle != null);
        if (this.filters == null) {
            return bundle;
        }
        BundleStreamSource stream = null;
        for (ObjectFilter filter : this.filters) {
            if (filter instanceof StreamFilter) {
                stream = ((StreamFilter)filter).init(bundle != null ? bundle.asStream() : stream);
                bundle = null;
                continue;
            }
            bundle = filter.filter(stream != null ? stream.asMultipleObjectsBundle() : bundle);
            stream = null;
        }
        return bundle != null ? bundle : stream.asMultipleObjectsBundle();
    }

    protected BundleStreamSource invokeStreamFilters(BundleStreamSource stream) {
        assert (stream != null);
        if (this.filters == null) {
            return stream;
        }
        MultipleObjectsBundle bundle = null;
        for (ObjectFilter filter : this.filters) {
            if (filter instanceof StreamFilter) {
                stream = ((StreamFilter)filter).init(bundle != null ? bundle.asStream() : stream);
                bundle = null;
                continue;
            }
            bundle = filter.filter(stream != null ? stream.asMultipleObjectsBundle() : bundle);
            stream = null;
        }
        return stream != null ? stream : bundle.asStream();
    }

    protected abstract Logging getLogger();

    public static abstract class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID FILTERS_ID = new OptionID("dbc.filter", "The filters to apply to the input data.");
        public static final OptionID PARSER_ID = new OptionID("dbc.parser", "Parser to provide the database.");
        protected List<ObjectFilter> filters;
        protected Parser parser = null;

        protected void configFilters(Parameterization config) {
            ObjectListParameter filterParam = new ObjectListParameter(FILTERS_ID, ObjectFilter.class, true);
            if (config.grab(filterParam)) {
                this.filters = filterParam.instantiateClasses(config);
            }
        }

        protected void configParser(Parameterization config, Class<?> parserRestrictionClass, Class<?> parserDefaultValueClass) {
            ObjectParameter parserParam = new ObjectParameter(PARSER_ID, parserRestrictionClass, parserDefaultValueClass);
            if (config.grab(parserParam)) {
                this.parser = (Parser)parserParam.instantiateClass(config);
            }
        }
    }
}

