/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource;

import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.database.ids.DBIDFactory;
import de.lmu.ifi.dbs.elki.datasource.AbstractDatabaseConnection;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.datasource.filter.ObjectFilter;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ArrayAdapterDatabaseConnection
extends AbstractDatabaseConnection {
    private static final Logging LOG = Logging.getLogger(ArrayAdapterDatabaseConnection.class);
    double[][] data;
    String[] labels;
    Integer startid = null;

    public ArrayAdapterDatabaseConnection(double[][] data) {
        this(data, null, null, null);
    }

    public ArrayAdapterDatabaseConnection(double[][] data, List<ObjectFilter> filters) {
        this(data, null, null, filters);
    }

    public ArrayAdapterDatabaseConnection(double[][] data, String[] labels) {
        this(data, labels, null, null);
    }

    public ArrayAdapterDatabaseConnection(double[][] data, String[] labels, List<ObjectFilter> filters) {
        this(data, labels, null, filters);
    }

    public ArrayAdapterDatabaseConnection(double[][] data, String[] labels, Integer startid) {
        this(data, labels, startid, null);
    }

    public ArrayAdapterDatabaseConnection(double[][] data, String[] labels, Integer startid, List<ObjectFilter> filters) {
        super(filters);
        this.data = data;
        this.labels = labels;
        this.startid = startid;
    }

    @Override
    public MultipleObjectsBundle loadData() {
        MultipleObjectsBundle b = new MultipleObjectsBundle();
        if (this.startid != null) {
            b.setDBIDs(DBIDFactory.FACTORY.generateStaticDBIDRange(this.startid, this.data.length));
        }
        int mind = Integer.MAX_VALUE;
        int maxd = 0;
        ArrayList<DoubleVector> vecs = new ArrayList<DoubleVector>(this.data.length);
        for (int i = 0; i < this.data.length; ++i) {
            int d = this.data[i].length;
            mind = d < mind ? d : mind;
            maxd = d > maxd ? d : maxd;
            vecs.add(DoubleVector.wrap(this.data[i]));
        }
        VectorFieldTypeInformation<DoubleVector> type = new VectorFieldTypeInformation<DoubleVector>(DoubleVector.FACTORY, mind, maxd, DoubleVector.FACTORY.getDefaultSerializer());
        b.appendColumn(type, vecs);
        if (this.labels != null) {
            if (this.labels.length != this.data.length) {
                throw new AbortException("Label and DBID columns must have the same size.");
            }
            b.appendColumn(TypeUtil.STRING, Arrays.asList(this.labels));
        }
        return this.invokeBundleFilters(b);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }
}

