/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource;

import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.datasource.AbstractDatabaseConnection;
import de.lmu.ifi.dbs.elki.datasource.FileBasedDatabaseConnection;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.datasource.filter.ObjectFilter;
import de.lmu.ifi.dbs.elki.datasource.parser.NumberVectorLabelParser;
import de.lmu.ifi.dbs.elki.datasource.parser.Parser;
import de.lmu.ifi.dbs.elki.datasource.parser.StreamingParser;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.io.FileUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.FileListParameter;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ConcatenateFilesDatabaseConnection
extends AbstractDatabaseConnection {
    private static final Logging LOG = Logging.getLogger(ConcatenateFilesDatabaseConnection.class);
    private List<File> files;
    private Parser parser;

    public ConcatenateFilesDatabaseConnection(List<File> files, Parser parser, List<ObjectFilter> filters) {
        super(filters);
        this.files = files;
        this.parser = parser;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public MultipleObjectsBundle loadData() {
        objects = new MultipleObjectsBundle();
        objects.appendColumn(TypeUtil.STRING, new ArrayList<E>());
lbl4:
        // 10 sources

        for (File file : this.files) {
            filestr = file.getPath();
            try {
                fis = new FileInputStream(file);
                var6_7 = null;
                try {
                    inputStream = FileUtil.tryGzipInput(new BufferedInputStream(fis));
                    var8_11 = null;
                    try {
                        if (this.parser instanceof StreamingParser) {
                            streamParser = (StreamingParser)this.parser;
                            streamParser.initStream(inputStream);
                            source = streamParser;
                        } else {
                            parsingResult = this.parser.parse(inputStream);
                            source = parsingResult.asStream();
                        }
                        meta = null;
                        e = source.nextEvent();
                        block26: while (true) {
                            switch (1.$SwitchMap$de$lmu$ifi$dbs$elki$datasource$bundle$BundleStreamSource$Event[e.ordinal()]) {
                                case 1: {
                                    ** break;
                                }
                                case 2: {
                                    meta = source.getMeta();
                                    for (i = 0; i < meta.size(); ++i) {
                                        if (i + 1 >= objects.metaLength()) {
                                            objects.appendColumn((SimpleTypeInformation)meta.get(i), new ArrayList<E>());
                                            continue;
                                        }
                                        if (objects.meta(i + 1).isAssignableFromType((TypeInformation)meta.get(i))) continue;
                                        throw new AbortException("Incompatible files loaded. Cannot concatenate with unaligned columns, please preprocess manually.");
                                    }
                                    ** GOTO lbl43
                                }
                                case 3: {
                                    o = new Object[objects.metaLength()];
                                    o[0] = filestr;
                                    for (i = 0; i < meta.size(); ++i) {
                                        o[i + 1] = source.data(i);
                                    }
                                    objects.appendSimple(o);
                                }
lbl43:
                                // 3 sources

                                default: {
                                    e = source.nextEvent();
                                    continue block26;
                                }
                            }
                            break;
                        }
                    }
                    catch (Throwable var9_14) {
                        var8_11 = var9_14;
                        throw var9_14;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (var8_11 != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable var9_13) {
                                var8_11.addSuppressed(var9_13);
                            }
                            continue;
                        }
                        inputStream.close();
                    }
                }
                catch (Throwable var7_10) {
                    var6_7 = var7_10;
                    throw var7_10;
                }
                finally {
                    if (fis == null) continue;
                    if (var6_7 != null) {
                        try {
                            fis.close();
                        }
                        catch (Throwable var7_9) {
                            var6_7.addSuppressed(var7_9);
                        }
                        continue;
                    }
                    fis.close();
                }
            }
            catch (IOException e) {
                throw new AbortException("Loading file " + filestr + " failed: " + e.toString(), e);
            }
        }
        this.parser.cleanup();
        if (ConcatenateFilesDatabaseConnection.LOG.isDebugging()) {
            ConcatenateFilesDatabaseConnection.LOG.debugFine("Invoking filters.");
        }
        return this.invokeBundleFilters(objects);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer
    extends AbstractDatabaseConnection.Parameterizer {
        public static final OptionID INPUT_ID = FileBasedDatabaseConnection.Parameterizer.INPUT_ID;
        private List<File> files;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            FileListParameter filesP = new FileListParameter(INPUT_ID, FileListParameter.FilesType.INPUT_FILES);
            if (config.grab(filesP)) {
                this.files = (List)filesP.getValue();
            }
            this.configFilters(config);
            this.configParser(config, Parser.class, NumberVectorLabelParser.class);
        }

        @Override
        protected ConcatenateFilesDatabaseConnection makeInstance() {
            return new ConcatenateFilesDatabaseConnection(this.files, this.parser, this.filters);
        }
    }
}

