/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource;

import de.lmu.ifi.dbs.elki.datasource.InputStreamDatabaseConnection;
import de.lmu.ifi.dbs.elki.datasource.filter.ObjectFilter;
import de.lmu.ifi.dbs.elki.datasource.parser.ArffParser;
import de.lmu.ifi.dbs.elki.datasource.parser.NumberVectorLabelParser;
import de.lmu.ifi.dbs.elki.datasource.parser.Parser;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.Priority;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.io.FileUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.FileParameter;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

@Alias(value={"de.lmu.ifi.dbs.elki.database.connection.FileBasedDatabaseConnection"})
@Priority(value=100)
public class FileBasedDatabaseConnection
extends InputStreamDatabaseConnection {
    public FileBasedDatabaseConnection(List<ObjectFilter> filters, Parser parser, File infile) {
        super(() -> {
            try {
                return new BufferedInputStream(FileUtil.tryGzipInput(new FileInputStream(infile)));
            }
            catch (IOException e) {
                throw new AbortException("Could not load input file: " + infile, e);
            }
        }, filters, parser);
    }

    public FileBasedDatabaseConnection(List<ObjectFilter> filters, Parser parser, String infile) {
        super(() -> {
            try {
                return new BufferedInputStream(FileUtil.tryGzipInput(new FileInputStream(infile)));
            }
            catch (IOException e) {
                throw new AbortException("Could not load input file: " + infile, e);
            }
        }, filters, parser);
    }

    public FileBasedDatabaseConnection(List<ObjectFilter> filters, Parser parser, InputStream in) {
        super(in, filters, parser);
    }

    public static class Parameterizer
    extends InputStreamDatabaseConnection.Parameterizer {
        public static final OptionID INPUT_ID = new OptionID("dbc.in", "The name of the input file to be parsed.");
        protected File infile;

        @Override
        protected void makeOptions(Parameterization config) {
            Class defaultParser = NumberVectorLabelParser.class;
            FileParameter inputParam = new FileParameter(INPUT_ID, FileParameter.FileType.INPUT_FILE);
            if (config.grab(inputParam)) {
                this.infile = (File)inputParam.getValue();
                String nam = this.infile.getName();
                if (nam != null && (nam.endsWith(".arff") || nam.endsWith(".arff.gz"))) {
                    defaultParser = ArffParser.class;
                }
            }
            this.configParser(config, Parser.class, defaultParser);
            this.configFilters(config);
        }

        @Override
        protected FileBasedDatabaseConnection makeInstance() {
            return new FileBasedDatabaseConnection((List<ObjectFilter>)this.filters, this.parser, this.infile);
        }
    }
}

