/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource;

import de.lmu.ifi.dbs.elki.datasource.AbstractDatabaseConnection;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.datasource.filter.ObjectFilter;
import de.lmu.ifi.dbs.elki.datasource.parser.NumberVectorLabelParser;
import de.lmu.ifi.dbs.elki.datasource.parser.Parser;
import de.lmu.ifi.dbs.elki.datasource.parser.StreamingParser;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.statistics.Duration;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.function.Supplier;

@Title(value="Input-Stream based database connection")
@Description(value="Parse an input stream such as STDIN into a database.")
public class InputStreamDatabaseConnection
extends AbstractDatabaseConnection
implements AutoCloseable {
    private static final Logging LOG = Logging.getLogger(InputStreamDatabaseConnection.class);
    Parser parser;
    Supplier<InputStream> in = () -> System.in;
    InputStream ins;

    public InputStreamDatabaseConnection(Supplier<InputStream> in, List<ObjectFilter> filters, Parser parser) {
        super(filters);
        this.in = in;
        this.parser = parser;
    }

    public InputStreamDatabaseConnection(InputStream ins, List<ObjectFilter> filters, Parser parser) {
        super(filters);
        this.ins = ins;
        this.parser = parser;
    }

    @Override
    public MultipleObjectsBundle loadData() {
        if (LOG.isDebugging()) {
            LOG.debugFine("Invoking parsers.");
        }
        if (this.parser instanceof StreamingParser) {
            StreamingParser streamParser = (StreamingParser)this.parser;
            this.ins = this.ins != null ? this.ins : this.in.get();
            streamParser.initStream(this.ins);
            if (LOG.isDebugging()) {
                LOG.debugFine("Parsing as stream.");
            }
            Duration duration = LOG.isStatistics() ? LOG.newDuration(this.getClass().getName() + ".load").begin() : null;
            MultipleObjectsBundle objects = this.invokeStreamFilters(streamParser).asMultipleObjectsBundle();
            this.parser.cleanup();
            if (duration != null) {
                LOG.statistics(duration.end());
            }
            return objects;
        }
        Duration duration = LOG.isStatistics() ? LOG.newDuration(this.getClass().getName() + ".parse").begin() : null;
        this.ins = this.ins != null ? this.ins : this.in.get();
        MultipleObjectsBundle parsingResult = this.parser.parse(this.ins);
        this.parser.cleanup();
        if (duration != null) {
            LOG.statistics(duration.end());
        }
        if (LOG.isDebugging()) {
            LOG.debugFine("Invoking filters.");
        }
        Duration fduration = LOG.isStatistics() ? LOG.newDuration(this.getClass().getName() + ".filter").begin() : null;
        MultipleObjectsBundle objects = this.invokeBundleFilters(parsingResult);
        if (fduration != null) {
            LOG.statistics(fduration.end());
        }
        return objects;
    }

    @Override
    public void close() throws IOException {
        if (this.ins != null) {
            this.ins.close();
            this.ins = null;
        }
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer
    extends AbstractDatabaseConnection.Parameterizer {
        public static final OptionID STREAM_ID = new OptionID("dbc.inputstream", "Input stream to read. Defaults to standard input.");
        protected InputStream instream;

        @Override
        protected void makeOptions(Parameterization config) {
            ObjectParameter inP = new ObjectParameter(STREAM_ID, InputStream.class, System.in);
            if (config.grab(inP)) {
                this.instream = (InputStream)inP.instantiateClass(config);
            }
            this.configParser(config, Parser.class, NumberVectorLabelParser.class);
            this.configFilters(config);
        }

        @Override
        protected InputStreamDatabaseConnection makeInstance() {
            return new InputStreamDatabaseConnection(this.instream, (List<ObjectFilter>)this.filters, this.parser);
        }
    }
}

