/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource;

import de.lmu.ifi.dbs.elki.data.LabelList;
import de.lmu.ifi.dbs.elki.datasource.AbstractDatabaseConnection;
import de.lmu.ifi.dbs.elki.datasource.DatabaseConnection;
import de.lmu.ifi.dbs.elki.datasource.ExternalIDJoinDatabaseConnection;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.datasource.filter.FilterUtil;
import de.lmu.ifi.dbs.elki.datasource.filter.ObjectFilter;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.io.FormatUtil;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectListParameter;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;

public class LabelJoinDatabaseConnection
extends AbstractDatabaseConnection {
    private static final Logging LOG = Logging.getLogger(LabelJoinDatabaseConnection.class);
    protected final List<DatabaseConnection> sources;

    public LabelJoinDatabaseConnection(List<ObjectFilter> filters, List<DatabaseConnection> sources) {
        super(filters);
        this.sources = sources;
    }

    @Override
    public MultipleObjectsBundle loadData() {
        ArrayList<MultipleObjectsBundle> bundles = new ArrayList<MultipleObjectsBundle>(this.sources.size());
        for (DatabaseConnection dbc : this.sources) {
            bundles.add(dbc.loadData());
        }
        MultipleObjectsBundle first = (MultipleObjectsBundle)bundles.get(0);
        Object2IntOpenHashMap<String> labelmap = new Object2IntOpenHashMap<String>(first.dataLength());
        labelmap.defaultReturnValue(-1);
        int lblcol = FilterUtil.findLabelColumn(first);
        if (lblcol == -1) {
            throw new AbortException("No label column found in first source, cannot join (do you want to use " + ExternalIDJoinDatabaseConnection.class.getSimpleName() + " instead?)");
        }
        for (int i = 0; i < first.dataLength(); ++i) {
            Object data = first.data(i, lblcol);
            if (data == null) {
                LOG.warning("Object without label encountered.");
                continue;
            }
            if (data instanceof String) {
                int old = labelmap.put((String)data, i);
                if (old == -1) continue;
                LOG.warning("Duplicate label encountered: " + data + " in rows " + old + " and " + i);
                continue;
            }
            if (data instanceof LabelList) {
                LabelList ll = (LabelList)data;
                for (int j = 0; j < ll.size(); ++j) {
                    String lbl = ll.get(j);
                    int old = labelmap.put(lbl, i);
                    if (old == -1) continue;
                    LOG.warning("Duplicate label encountered: " + lbl + " in rows " + old + " and " + i);
                }
                continue;
            }
            String lbl = data.toString();
            int old = labelmap.put(lbl, i);
            if (old == -1) continue;
            LOG.warning("Duplicate label encountered: " + lbl + " in rows " + old + " and " + i);
        }
        for (int c = 1; c < this.sources.size(); ++c) {
            int i;
            MultipleObjectsBundle cur = (MultipleObjectsBundle)bundles.get(c);
            int lblcol2 = FilterUtil.findLabelColumn(cur);
            if (lblcol2 == -1) {
                throw new AbortException("No label column found in source " + (c + 1) + ", cannot join (do you want to use " + ExternalIDJoinDatabaseConnection.class.getSimpleName() + " instead?)");
            }
            ArrayList dcol = new ArrayList(cur.metaLength());
            for (i = 0; i < cur.metaLength(); ++i) {
                if (i == lblcol2) {
                    dcol.add(null);
                    continue;
                }
                ArrayList<Object> newcol = new ArrayList<Object>(first.dataLength());
                for (int j = 0; j < first.dataLength(); ++j) {
                    newcol.add(null);
                }
                first.appendColumn(cur.meta(i), newcol);
                dcol.add(newcol);
            }
            for (i = 0; i < cur.dataLength(); ++i) {
                Object data = cur.data(i, lblcol2);
                if (data == null) {
                    LOG.warning("Object without label encountered.");
                    continue;
                }
                int row = -1;
                if (data instanceof String) {
                    row = labelmap.getInt(data);
                } else if (data instanceof LabelList) {
                    LabelList ll = (LabelList)data;
                    for (int j = 0; j < ll.size() && (row = labelmap.getInt(ll.get(j))) < 0; ++j) {
                    }
                } else {
                    row = labelmap.getInt(data.toString());
                }
                if (row < 0) {
                    LOG.warning("Label not found for join: " + data + " in row " + i);
                    continue;
                }
                for (int d = 0; d < cur.metaLength(); ++d) {
                    if (d == lblcol2) continue;
                    List col = (List)dcol.get(d);
                    assert (col != null);
                    col.set(row, cur.data(i, d));
                }
            }
        }
        block9: for (int i = 0; i < first.dataLength(); ++i) {
            for (int d = 0; d < first.metaLength(); ++d) {
                if (first.data(i, d) != null) continue;
                StringBuilder buf = new StringBuilder();
                for (int d2 = 0; d2 < first.metaLength(); ++d2) {
                    if (buf.length() > 0) {
                        buf.append(", ");
                    }
                    if (first.data(i, d2) == null) {
                        buf.append("null");
                        continue;
                    }
                    buf.append(first.data(i, d2));
                }
                LOG.warning("null value in joined data, row " + i + " column " + d + FormatUtil.NEWLINE + "[" + buf.toString() + "]");
                continue block9;
            }
        }
        return first;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer
    extends AbstractDatabaseConnection.Parameterizer {
        public static final OptionID SOURCES_ID = new OptionID("join.sources", "The data sources to join.");
        protected List<DatabaseConnection> sources;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            super.configFilters(config);
            ObjectListParameter sourcesParam = new ObjectListParameter(SOURCES_ID, DatabaseConnection.class);
            if (config.grab(sourcesParam)) {
                this.sources = sourcesParam.instantiateClasses(config);
            }
        }

        @Override
        protected LabelJoinDatabaseConnection makeInstance() {
            return new LabelJoinDatabaseConnection(this.filters, this.sources);
        }
    }
}

