/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource;

import de.lmu.ifi.dbs.elki.datasource.AbstractDatabaseConnection;
import de.lmu.ifi.dbs.elki.datasource.DatabaseConnection;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.datasource.filter.ObjectFilter;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectListParameter;
import java.util.ArrayList;
import java.util.List;

@Description(value="Blindly joins multiple data sources, assuming they are ordered the same way.")
public class PresortedBlindJoinDatabaseConnection
extends AbstractDatabaseConnection {
    private static final Logging LOG = Logging.getLogger(PresortedBlindJoinDatabaseConnection.class);
    protected final List<DatabaseConnection> sources;

    public PresortedBlindJoinDatabaseConnection(List<ObjectFilter> filters, List<DatabaseConnection> sources) {
        super(filters);
        this.sources = sources;
    }

    @Override
    public MultipleObjectsBundle loadData() {
        ArrayList<MultipleObjectsBundle> bundles = new ArrayList<MultipleObjectsBundle>(this.sources.size());
        for (DatabaseConnection dbc : this.sources) {
            bundles.add(dbc.loadData());
        }
        MultipleObjectsBundle first = (MultipleObjectsBundle)bundles.get(0);
        for (int c = 1; c < this.sources.size(); ++c) {
            MultipleObjectsBundle cur = (MultipleObjectsBundle)bundles.get(c);
            if (cur.dataLength() != first.dataLength()) {
                throw new AbortException("Data set sizes do not agree - cannot join!");
            }
            for (int i = 0; i < cur.metaLength(); ++i) {
                first.appendColumn(cur.meta(i), cur.getColumn(i));
            }
        }
        return this.invokeBundleFilters(first);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer
    extends AbstractDatabaseConnection.Parameterizer {
        public static final OptionID SOURCES_ID = new OptionID("join.sources", "The data sources to join.");
        protected List<DatabaseConnection> sources;

        @Override
        protected void makeOptions(Parameterization config) {
            super.makeOptions(config);
            super.configFilters(config);
            ObjectListParameter sourcesParam = new ObjectListParameter(SOURCES_ID, DatabaseConnection.class);
            if (config.grab(sourcesParam)) {
                this.sources = sourcesParam.instantiateClasses(config);
            }
        }

        @Override
        protected PresortedBlindJoinDatabaseConnection makeInstance() {
            return new PresortedBlindJoinDatabaseConnection(this.filters, this.sources);
        }
    }
}

