/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource;

import de.lmu.ifi.dbs.elki.data.DoubleVector;
import de.lmu.ifi.dbs.elki.data.VectorUtil;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.datasource.AbstractDatabaseConnection;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.datasource.filter.ObjectFilter;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.RandomParameter;
import de.lmu.ifi.dbs.elki.utilities.random.RandomFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class RandomDoubleVectorDatabaseConnection
extends AbstractDatabaseConnection {
    private static final Logging LOG = Logging.getLogger(RandomDoubleVectorDatabaseConnection.class);
    protected int dim = -1;
    protected int size = -1;
    protected RandomFactory rnd;

    public RandomDoubleVectorDatabaseConnection(int dim, int size, RandomFactory rnd, List<ObjectFilter> filters) {
        super(filters);
        this.dim = dim;
        this.size = size;
        this.rnd = rnd;
    }

    @Override
    public MultipleObjectsBundle loadData() {
        VectorFieldTypeInformation<DoubleVector> type = new VectorFieldTypeInformation<DoubleVector>(DoubleVector.FACTORY, this.dim);
        ArrayList<DoubleVector> vectors = new ArrayList<DoubleVector>(this.size);
        Random rand = this.rnd.getSingleThreadedRandom();
        for (int i = 0; i < this.size; ++i) {
            vectors.add(VectorUtil.randomVector(DoubleVector.FACTORY, this.dim, rand));
        }
        return MultipleObjectsBundle.makeSimple(type, vectors);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer
    extends AbstractDatabaseConnection.Parameterizer {
        public static final OptionID SEED_ID = new OptionID("dbc.genseed", "Seed for randomly generating vectors");
        public static final OptionID DIM_ID = new OptionID("dbc.dim", "Dimensionality of the vectors to generate.");
        public static final OptionID SIZE_ID = new OptionID("dbc.size", "Database size to generate.");
        int dim = -1;
        int size = -1;
        RandomFactory rnd;

        @Override
        protected void makeOptions(Parameterization config) {
            RandomParameter rndP;
            IntParameter sizeParam;
            super.makeOptions(config);
            this.configFilters(config);
            IntParameter dimParam = new IntParameter(DIM_ID);
            if (config.grab(dimParam)) {
                this.dim = dimParam.intValue();
            }
            if (config.grab(sizeParam = new IntParameter(SIZE_ID))) {
                this.size = sizeParam.intValue();
            }
            if (config.grab(rndP = new RandomParameter(SEED_ID))) {
                this.rnd = (RandomFactory)rndP.getValue();
            }
        }

        @Override
        protected RandomDoubleVectorDatabaseConnection makeInstance() {
            return new RandomDoubleVectorDatabaseConnection(this.dim, this.size, this.rnd, this.filters);
        }
    }
}

