/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.bundle;

import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformationSerializer;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleMeta;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleStreamSource;
import de.lmu.ifi.dbs.elki.datasource.bundle.MultipleObjectsBundle;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.io.ByteArrayUtil;
import de.lmu.ifi.dbs.elki.utilities.io.ByteBufferSerializer;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;

public class BundleReader
implements BundleStreamSource {
    public static final int MAGIC = -1475200238;
    MappedByteBuffer buffer = null;
    BundleMeta meta = null;
    FileChannel input = null;
    ByteBufferSerializer<?>[] sers;
    Object[] data;
    boolean hasids = false;

    public BundleReader(MappedByteBuffer buffer) {
        this.buffer = buffer;
        this.input = null;
    }

    public BundleReader(FileChannel input) {
        this.input = input;
    }

    @Override
    public BundleMeta getMeta() {
        if (this.meta == null) {
            this.openBuffer();
            this.readMeta();
        }
        return this.meta;
    }

    void openBuffer() {
        if (this.buffer == null) {
            try {
                this.buffer = this.input.map(FileChannel.MapMode.READ_ONLY, 0L, this.input.size());
            }
            catch (IOException e) {
                throw new AbortException("Cannot map input bundle.", e);
            }
        }
    }

    void readMeta() {
        int check = this.buffer.getInt();
        if (check != -1475200238) {
            throw new AbortException("File does not start with expected magic.");
        }
        int nummeta = this.buffer.getInt();
        assert (nummeta > 0) : "Empty bundle?";
        this.meta = new BundleMeta(nummeta);
        this.sers = new ByteBufferSerializer[nummeta];
        this.data = new Object[nummeta];
        for (int i = 0; i < nummeta; ++i) {
            try {
                SimpleTypeInformation type = (SimpleTypeInformation)TypeInformationSerializer.STATIC.fromByteBuffer(this.buffer);
                this.sers[i] = type.getSerializer();
                if (i == 0 && DBID.class.isAssignableFrom(type.getRestrictionClass())) {
                    this.hasids = true;
                    continue;
                }
                this.meta.add(type);
                continue;
            }
            catch (UnsupportedOperationException e) {
                throw new AbortException("Deserialization failed: " + e.getMessage(), e);
            }
            catch (IOException e) {
                throw new AbortException("IO error", e);
            }
        }
    }

    void readObject() {
        for (int i = 0; i < this.sers.length; ++i) {
            try {
                this.data[i] = this.sers[i].fromByteBuffer(this.buffer);
                continue;
            }
            catch (UnsupportedOperationException e) {
                throw new AbortException("Deserialization failed.", e);
            }
            catch (IOException e) {
                throw new AbortException("IO error", e);
            }
        }
    }

    @Override
    public BundleStreamSource.Event nextEvent() {
        if (this.meta == null) {
            return BundleStreamSource.Event.META_CHANGED;
        }
        if (this.buffer.remaining() == 0) {
            ByteArrayUtil.unmapByteBuffer(this.buffer);
            return BundleStreamSource.Event.END_OF_STREAM;
        }
        this.readObject();
        return BundleStreamSource.Event.NEXT_OBJECT;
    }

    @Override
    public Object data(int rnum) {
        return this.data[!this.hasids ? rnum : rnum + 1];
    }

    @Override
    public boolean hasDBIDs() {
        return this.hasids;
    }

    @Override
    public boolean assignDBID(DBIDVar var) {
        if (!this.hasids) {
            return false;
        }
        var.set((DBID)this.data[0]);
        return true;
    }

    @Override
    public MultipleObjectsBundle asMultipleObjectsBundle() {
        return MultipleObjectsBundle.fromStream(this);
    }
}

