/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource.bundle;

import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformationSerializer;
import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDFactory;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleMeta;
import de.lmu.ifi.dbs.elki.datasource.bundle.BundleStreamSource;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.io.ByteBufferSerializer;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public class BundleWriter {
    private static final Logging LOG = Logging.getLogger(BundleWriter.class);
    private static final int INITIAL_BUFFER = 4096;
    public static final int MAGIC = -1475200238;

    public void writeBundleStream(BundleStreamSource source, WritableByteChannel output) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(4096);
        DBIDVar var = DBIDUtil.newVar();
        ByteBufferSerializer<?>[] serializers = null;
        block5: while (true) {
            BundleStreamSource.Event ev = source.nextEvent();
            switch (ev) {
                case NEXT_OBJECT: {
                    if (serializers == null) {
                        serializers = this.writeHeader(source, buffer, output);
                    }
                    if (serializers[0] != null) {
                        if (!source.assignDBID(var)) {
                            throw new AbortException("An object did not have an DBID assigned.");
                        }
                        DBID id = DBIDUtil.deref(var);
                        ByteBufferSerializer<?> ser = serializers[0];
                        int size = ser.getByteSize(id);
                        buffer = this.ensureBuffer(size, buffer, output);
                        ser.toByteBuffer(buffer, id);
                    }
                    int i = 1;
                    int j = 0;
                    while (true) {
                        if (i >= serializers.length) continue block5;
                        ByteBufferSerializer<?> ser = serializers[i];
                        int size = ser.getByteSize(source.data(j));
                        buffer = this.ensureBuffer(size, buffer, output);
                        ser.toByteBuffer(buffer, source.data(j));
                        ++i;
                        ++j;
                    }
                }
                case META_CHANGED: {
                    if (serializers == null) continue block5;
                    throw new AbortException("Meta changes are not supported, once the block header has been written.");
                }
                case END_OF_STREAM: {
                    break block5;
                }
                default: {
                    LOG.warning("Unknown bundle stream event. API inconsistent? " + (Object)((Object)ev));
                }
            }
        }
        if (buffer.position() > 0) {
            this.flushBuffer(buffer, output);
        }
    }

    private void flushBuffer(ByteBuffer buffer, WritableByteChannel output) throws IOException {
        buffer.flip();
        output.write(buffer);
        buffer.flip();
        buffer.limit(buffer.capacity());
    }

    private ByteBuffer ensureBuffer(int size, ByteBuffer buffer, WritableByteChannel output) throws IOException {
        if (buffer.remaining() >= size) {
            return buffer;
        }
        this.flushBuffer(buffer, output);
        if (buffer.remaining() >= size) {
            return buffer;
        }
        return ByteBuffer.allocateDirect(Math.max(buffer.capacity() << 1, buffer.capacity() + size));
    }

    private ByteBufferSerializer<?>[] writeHeader(BundleStreamSource source, ByteBuffer buffer, WritableByteChannel output) throws IOException {
        BundleMeta meta = source.getMeta();
        int nummeta = meta.size();
        ByteBufferSerializer[] serializers = new ByteBufferSerializer[1 + nummeta];
        assert (buffer.position() == 0) : "Buffer is supposed to be at 0.";
        buffer.putInt(-1475200238);
        if (source.hasDBIDs()) {
            buffer.putInt(1 + nummeta);
            ByteBufferSerializer<DBID> ser = DBIDFactory.FACTORY.getDBIDSerializer();
            TypeInformationSerializer.STATIC.toByteBuffer(buffer, new SimpleTypeInformation<DBID>(DBID.class, ser));
            serializers[0] = ser;
        } else {
            buffer.putInt(nummeta);
        }
        for (int i = 0; i < nummeta; ++i) {
            SimpleTypeInformation type = (SimpleTypeInformation)meta.get(i);
            ByteBufferSerializer ser = type.getSerializer();
            if (ser == null) {
                throw new AbortException("Cannot serialize - no serializer found for type: " + type.toString());
            }
            TypeInformationSerializer.STATIC.toByteBuffer(buffer, type);
            serializers[i + 1] = ser;
        }
        return serializers;
    }
}

